/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.vars;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.main.collectors.VarNamesCollector;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarDefinitionHelper;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionsProcessor;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.TextUtil;

public class VarProcessor {
    private final StructMethod method;
    private final MethodDescriptor methodDescriptor;
    private Map<VarVersionPair, String> mapVarNames = new HashMap<VarVersionPair, String>();
    private VarVersionsProcessor varVersions;
    private final Map<VarVersionPair, String> thisVars = new HashMap<VarVersionPair, String>();
    private final Set<VarVersionPair> externalVars = new HashSet<VarVersionPair>();

    public VarProcessor(StructMethod mt, MethodDescriptor md) {
        this.method = mt;
        this.methodDescriptor = md;
    }

    public void setVarVersions(RootStatement root) {
        this.varVersions = new VarVersionsProcessor(this.method, this.methodDescriptor);
        this.varVersions.setVarVersions(root);
    }

    public void setVarDefinitions(Statement root) {
        this.mapVarNames = new HashMap<VarVersionPair, String>();
        new VarDefinitionHelper(root, this.method, this).setVarDefinitions();
    }

    public void setDebugVarNames(Map<Integer, String> mapDebugVarNames) {
        if (this.varVersions == null) {
            return;
        }
        Map<Integer, Integer> mapOriginalVarIndices = this.varVersions.getMapOriginalVarIndices();
        ArrayList<VarVersionPair> listVars = new ArrayList<VarVersionPair>(this.mapVarNames.keySet());
        Collections.sort(listVars, new Comparator<VarVersionPair>(){

            @Override
            public int compare(VarVersionPair o1, VarVersionPair o2) {
                return o1.var - o2.var;
            }
        });
        HashMap<String, Integer> mapNames = new HashMap<String, Integer>();
        for (VarVersionPair pair : listVars) {
            Integer counter;
            String debugName;
            String name = this.mapVarNames.get(pair);
            Integer index = mapOriginalVarIndices.get(pair.var);
            if (index != null && (debugName = mapDebugVarNames.get(index)) != null && TextUtil.isValidIdentifier(debugName, this.method.getClassStruct().getBytecodeVersion())) {
                name = debugName;
            }
            mapNames.put(name, (counter = (Integer)mapNames.get(name)) == null ? (counter = new Integer(0)) : (counter = Integer.valueOf(counter + 1)));
            if (counter > 0) {
                name = name + String.valueOf(counter);
            }
            this.mapVarNames.put(pair, name);
        }
    }

    public void refreshVarNames(VarNamesCollector vc) {
        HashMap<VarVersionPair, String> tempVarNames = new HashMap<VarVersionPair, String>(this.mapVarNames);
        for (Map.Entry ent : tempVarNames.entrySet()) {
            this.mapVarNames.put((VarVersionPair)ent.getKey(), vc.getFreeName((String)ent.getValue()));
        }
    }

    public VarType getVarType(VarVersionPair pair) {
        return this.varVersions == null ? null : this.varVersions.getVarType(pair);
    }

    public void setVarType(VarVersionPair pair, VarType type) {
        this.varVersions.setVarType(pair, type);
    }

    public String getVarName(VarVersionPair pair) {
        return this.mapVarNames == null ? null : this.mapVarNames.get(pair);
    }

    public void setVarName(VarVersionPair pair, String name) {
        this.mapVarNames.put(pair, name);
    }

    public int getVarFinal(VarVersionPair pair) {
        return this.varVersions == null ? 3 : this.varVersions.getVarFinal(pair);
    }

    public void setVarFinal(VarVersionPair pair, int finalType) {
        this.varVersions.setVarFinal(pair, finalType);
    }

    public Map<VarVersionPair, String> getThisVars() {
        return this.thisVars;
    }

    public Set<VarVersionPair> getExternalVars() {
        return this.externalVars;
    }
}

