/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.resources;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.jboss.forge.addon.maven.resources.MavenDependencyResourceImpl;
import org.jboss.forge.addon.maven.resources.MavenModelResource;
import org.jboss.forge.addon.maven.resources.MavenProfileResourceImpl;
import org.jboss.forge.addon.maven.resources.MavenRepositoryResourceImpl;
import org.jboss.forge.addon.maven.resources.SortedProperties;
import org.jboss.forge.addon.maven.util.MavenJDOMWriter;
import org.jboss.forge.addon.parser.xml.resources.AbstractXMLResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.furnace.util.Streams;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class MavenModelResourceImpl
extends AbstractXMLResource
implements MavenModelResource {
    private Model currentModel;

    public MavenModelResourceImpl(ResourceFactory factory, File file) {
        super(factory, file);
    }

    public Resource<?> getChild(String name) {
        List chidren = this.listResources();
        for (Resource child : chidren) {
            if (!child.getName().trim().equals(name)) continue;
            return child;
        }
        return null;
    }

    protected List<Resource<?>> doListResources() {
        Model model = this.getCurrentModel();
        ArrayList children = new ArrayList();
        this.listDependencies(model, children);
        this.listProfiles(model, children);
        this.listRepositories(model, children);
        return children;
    }

    private void listRepositories(Model model, List<Resource<?>> children) {
        List repositories = model.getRepositories();
        for (Repository repository : repositories) {
            children.add((Resource<?>)new MavenRepositoryResourceImpl(this.getResourceFactory(), (Resource<?>)this.getParent(), repository));
        }
    }

    private void listDependencies(Model model, List<Resource<?>> children) {
        for (Dependency dep : model.getDependencies()) {
            children.add((Resource<?>)new MavenDependencyResourceImpl(this.getResourceFactory(), (Resource<?>)this, dep));
        }
    }

    private void listProfiles(Model model, List<Resource<?>> children) {
        List profiles = model.getProfiles();
        for (Profile profile : profiles) {
            children.add((Resource<?>)new MavenProfileResourceImpl(this.getResourceFactory(), (Resource<?>)this, profile));
        }
    }

    public Model getCurrentModel() {
        this.initialize();
        return this.currentModel.clone();
    }

    public MavenModelResource setCurrentModel(Model pom) {
        Throwable throwable;
        Document document;
        try (InputStream is = this.getResourceInputStream();){
            document = new SAXBuilder().build(is);
        }
        catch (JDOMException e) {
            throw new RuntimeException("Could not parse POM file: " + this.getFullyQualifiedName(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read POM file: " + this.getFullyQualifiedName(), e);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            throwable = null;
            try (OutputStreamWriter os = new OutputStreamWriter(baos);){
                MavenJDOMWriter writer = new MavenJDOMWriter();
                writer.write(pom, document, "UTF-8", os);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write POM file: " + this.getFullyQualifiedName(), e);
        }
        try {
            throwable = null;
            try (OutputStream resourceOutputStream = this.getResourceOutputStream();){
                Streams.write((InputStream)new ByteArrayInputStream(baos.toByteArray()), (OutputStream)resourceOutputStream);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error while writing to resource stream: " + this.getFullyQualifiedName(), e);
        }
        return this;
    }

    public Resource<File> createFrom(File file) {
        return new MavenModelResourceImpl(this.getResourceFactory(), file);
    }

    private void initialize() {
        if (this.isStale() || this.currentModel == null) {
            try (InputStream stream = this.getResourceInputStream();){
                MavenXpp3Reader reader = new MavenXpp3Reader();
                this.currentModel = reader.read(stream);
                this.currentModel.setPomFile(this.getUnderlyingResourceObject());
                SortedProperties sortedProps = new SortedProperties();
                sortedProps.putAll((Map<?, ?>)this.currentModel.getProperties());
                this.currentModel.setProperties((Properties)sortedProps);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.refresh();
            }
        }
    }
}

