/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.bridge.proxies.impl;

import java.io.Serializable;
import org.xadisk.bridge.proxies.facilitators.RemoteMethodInvoker;
import org.xadisk.bridge.proxies.facilitators.RemoteObjectProxy;
import org.xadisk.bridge.proxies.interfaces.XAFileOutputStream;
import org.xadisk.filesystem.exceptions.ClosedStreamException;
import org.xadisk.filesystem.exceptions.NoTransactionAssociatedException;

public class RemoteXAFileOutputStream
extends RemoteObjectProxy
implements XAFileOutputStream {
    private static final long serialVersionUID = 1L;

    public RemoteXAFileOutputStream(long objectId, RemoteMethodInvoker invoker) {
        super(objectId, invoker);
    }

    public void write(int b) throws ClosedStreamException, NoTransactionAssociatedException {
        try {
            this.invokeRemoteMethod("write", Integer.valueOf(b));
        }
        catch (NoTransactionAssociatedException tre) {
            throw tre;
        }
        catch (ClosedStreamException cse) {
            throw cse;
        }
        catch (Throwable t) {
            throw this.assertExceptionHandling(t);
        }
    }

    public void write(byte[] b) throws ClosedStreamException, NoTransactionAssociatedException {
        try {
            this.invokeRemoteMethod("write", new Serializable[]{b});
        }
        catch (NoTransactionAssociatedException tre) {
            throw tre;
        }
        catch (ClosedStreamException cse) {
            throw cse;
        }
        catch (Throwable t) {
            throw this.assertExceptionHandling(t);
        }
    }

    public void write(byte[] b, int off, int len) throws ClosedStreamException, NoTransactionAssociatedException {
        try {
            byte[] onWire = new byte[len];
            System.arraycopy(b, off, onWire, 0, len);
            this.invokeRemoteMethod("write", new Serializable[]{b, Integer.valueOf(off), Integer.valueOf(len)});
        }
        catch (NoTransactionAssociatedException tre) {
            throw tre;
        }
        catch (ClosedStreamException cse) {
            throw cse;
        }
        catch (Throwable t) {
            throw this.assertExceptionHandling(t);
        }
    }

    public void flush() throws ClosedStreamException, NoTransactionAssociatedException {
        try {
            this.invokeRemoteMethod("flush", new Serializable[0]);
        }
        catch (NoTransactionAssociatedException tre) {
            throw tre;
        }
        catch (ClosedStreamException cse) {
            throw cse;
        }
        catch (Throwable t) {
            throw this.assertExceptionHandling(t);
        }
    }

    public void close() throws NoTransactionAssociatedException {
        try {
            this.invokeRemoteMethod("close", new Serializable[0]);
        }
        catch (NoTransactionAssociatedException tre) {
            throw tre;
        }
        catch (Throwable t) {
            throw this.assertExceptionHandling(t);
        }
    }

    public boolean isClosed() {
        try {
            return (Boolean)this.invokeRemoteMethod("isClosed", new Serializable[0]);
        }
        catch (Throwable t) {
            throw this.assertExceptionHandling(t);
        }
    }
}

