/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.condition.annotation;

import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.condition.EvaluationStrategy;
import org.jboss.windup.rules.apps.java.condition.annotation.AnnotationCondition;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationLiteralTypeValueModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationTypeValueModel;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterizedPatternResult;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;

public class AnnotationLiteralCondition
extends AnnotationCondition {
    private RegexParameterizedPatternParser pattern;

    public AnnotationLiteralCondition(String pattern) {
        this.pattern = new RegexParameterizedPatternParser(pattern);
    }

    public String toString() {
        return "AnnotationLiteralCondition{pattern=" + this.pattern + '}';
    }

    @Override
    public boolean evaluate(GraphRewrite event, EvaluationContext context, EvaluationStrategy strategy, JavaAnnotationTypeValueModel value) {
        if (!(value instanceof JavaAnnotationLiteralTypeValueModel)) {
            return false;
        }
        JavaAnnotationLiteralTypeValueModel literalType = (JavaAnnotationLiteralTypeValueModel)value;
        if (this.pattern != null) {
            String annotationValue = literalType.getLiteralValue();
            ParameterizedPatternResult referenceResult = this.pattern.parse(annotationValue);
            if (!referenceResult.matches()) {
                return false;
            }
            if (!referenceResult.submit((Rewrite)event, context)) {
                return false;
            }
        }
        return true;
    }
}

