/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.decompiler;

import java.nio.file.Paths;
import java.util.List;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.model.JavaClassFileModel;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;

public abstract class AbstractDecompilerOperation
extends GraphOperation {
    private Iterable<JavaClassFileModel> filesToDecompile;

    Iterable<JavaClassFileModel> getFilesToDecompile(GraphContext context) {
        if (this.filesToDecompile == null) {
            this.filesToDecompile = this.getDefaultFilesToDecompile(context);
        }
        return this.filesToDecompile;
    }

    public void setFilesToDecompile(Iterable<JavaClassFileModel> filesToDecompile) {
        this.filesToDecompile = filesToDecompile;
    }

    private Iterable<JavaClassFileModel> getDefaultFilesToDecompile(GraphContext context) {
        GraphService classFileService = new GraphService(context, JavaClassFileModel.class);
        return classFileService.findAllWithoutProperty("skipDecompilation", (Object)true);
    }

    protected void setupClassToJavaConnections(GraphContext context, List<String> classFilesPaths, JavaSourceFileModel decompiledJavaFile) {
        FileService fileService = new FileService(context);
        for (String classFilePath : classFilesPaths) {
            FileModel classFileModel = (FileModel)fileService.getUniqueByProperty("filePath", (Object)Paths.get(classFilePath, new String[0]).toAbsolutePath().toString());
            if (!(classFileModel instanceof JavaClassFileModel)) continue;
            JavaClassFileModel javaClassFileModel = (JavaClassFileModel)classFileModel;
            javaClassFileModel.getJavaClass().setDecompiledSource(decompiledJavaFile);
        }
    }
}

