/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker;

import freemarker.ext.beans.StringModel;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateModelException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.traversal.ProjectModelTraversal;
import org.jboss.windup.reporting.freemarker.FreeMarkerUtil;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.InlineHintService;
import org.jboss.windup.util.ExecutionStatistics;

public class GetEffortDetailsForProjectTraversalMethod
implements WindupFreeMarkerMethod {
    public static final Logger LOG = Logger.getLogger(GetEffortDetailsForProjectTraversalMethod.class.getName());
    private static final String NAME = "getEffortDetailsForProjectTraversal";
    private ClassificationService classificationService;
    private InlineHintService inlineHintService;

    public void setContext(GraphRewrite event) {
        this.classificationService = new ClassificationService(event.getGraphContext());
        this.inlineHintService = new InlineHintService(event.getGraphContext());
    }

    public String getMethodName() {
        return NAME;
    }

    public String getDescription() {
        return "Takes a " + ProjectModel.class.getSimpleName() + " as a parameter and returns Map<Integer, Integer> where the key is the effort level and the value is the number of incidents at that particular level of effort.";
    }

    public Object exec(List arguments) throws TemplateModelException {
        ExecutionStatistics.get().begin(NAME);
        if (arguments.size() < 2) {
            throw new TemplateModelException("Error, method expects at least three arguments (projectModel: ProjectModel, recursive: Boolean, [includeTags: Set<String>], [excludeTags: Set<String>])");
        }
        StringModel projectModelTraversalArg = (StringModel)arguments.get(0);
        ProjectModelTraversal projectModelTraversal = (ProjectModelTraversal)projectModelTraversalArg.getWrappedObject();
        TemplateBooleanModel recursiveBooleanModel = (TemplateBooleanModel)arguments.get(1);
        boolean recursive = recursiveBooleanModel.getAsBoolean();
        Set includeTags = Collections.emptySet();
        if (arguments.size() >= 3) {
            includeTags = FreeMarkerUtil.simpleSequenceToSet((SimpleSequence)((SimpleSequence)arguments.get(2)));
        }
        Set excludeTags = Collections.emptySet();
        if (arguments.size() >= 4) {
            excludeTags = FreeMarkerUtil.simpleSequenceToSet((SimpleSequence)((SimpleSequence)arguments.get(3)));
        }
        Map classificationEffortDetails = this.classificationService.getMigrationEffortByPoints(projectModelTraversal, includeTags, excludeTags, recursive, false);
        Map hintEffortDetails = this.inlineHintService.getMigrationEffortByPoints(projectModelTraversal, includeTags, excludeTags, recursive, false);
        Map<Integer, Integer> results = this.sumMaps(classificationEffortDetails, hintEffortDetails);
        ExecutionStatistics.get().end(NAME);
        int points = this.sumPoints(results);
        LOG.info(String.format("%s() FM function called:\n\t\t\tEFFORT: %3d = %s = C%s + H%s; %s, %srecur, tags: %s, excl: %s", NAME, points, results, classificationEffortDetails, hintEffortDetails, projectModelTraversal, recursive ? "" : "!", includeTags, excludeTags));
        return results;
    }

    private Map<Integer, Integer> sumMaps(Map<Integer, Integer> classificationEffortDetails, Map<Integer, Integer> hintEffortDetails) {
        HashMap<Integer, Integer> results = new HashMap<Integer, Integer>(classificationEffortDetails.size() + hintEffortDetails.size());
        results.putAll(classificationEffortDetails);
        for (Map.Entry<Integer, Integer> entry : hintEffortDetails.entrySet()) {
            if (!results.containsKey(entry.getKey())) {
                results.put(entry.getKey(), entry.getValue());
                continue;
            }
            results.put(entry.getKey(), (Integer)results.get(entry.getKey()) + entry.getValue());
        }
        return results;
    }

    private int sumPoints(Map<Integer, Integer> results) {
        int sum = 0;
        for (Map.Entry<Integer, Integer> entry : results.entrySet()) {
            sum += entry.getKey() * entry.getValue();
        }
        return sum;
    }
}

