/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.renderer.gexf;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.reporting.renderer.GraphDataSerializer;

public class GexfWriter
implements GraphDataSerializer {
    protected final Graph graph;
    protected String defaultEdgeType = "directed";
    protected String mode = "static";
    protected String vertexLabelProperty = "label";
    protected String edgeLabel = null;

    public GexfWriter(Graph graph) {
        this.graph = graph;
    }

    public GexfWriter(Graph graph, String mode, String defaultEdgeType, String vertexLabelProperty, String edgeLabel) {
        this.graph = graph;
        this.mode = mode;
        this.defaultEdgeType = defaultEdgeType;
        this.vertexLabelProperty = vertexLabelProperty;
        this.edgeLabel = edgeLabel;
    }

    @Override
    public void writeGraph(OutputStream os) throws IOException {
        this.writeGexf(os);
    }

    private void writeGexf(OutputStream os) throws IOException {
        IOUtils.write((String)"<gexf xmlns=\"http://www.gexf.net/1.2draft\" version=\"1.2\">", (OutputStream)os);
        this.writeGraphTag(this.mode, this.defaultEdgeType, os);
        IOUtils.write((String)"</gexf>", (OutputStream)os);
    }

    private void writeGraphTag(String mode, String edgeType, OutputStream os) throws IOException {
        String tag = StringUtils.replaceEach((String)"<graph mode=\"%1\" defaultedgetype=\"%2\">", (String[])new String[]{"%1", "%2"}, (String[])new String[]{mode, edgeType});
        IOUtils.write((String)tag, (OutputStream)os);
        this.writeGraphNodes(os);
        this.writeGraphEdges(os);
        IOUtils.write((String)"</graph>", (OutputStream)os);
    }

    private void writeGraphEdges(OutputStream os) throws IOException {
        IOUtils.write((String)"<edges>", (OutputStream)os);
        for (Edge edge : this.graph.getEdges()) {
            String id = "" + edge.getId().hashCode();
            String source = "" + edge.getVertex(Direction.OUT).getId().toString();
            String target = "" + edge.getVertex(Direction.IN).getId().toString();
            this.writeGraphEdge(id, source, target, os);
        }
        IOUtils.write((String)"</edges>", (OutputStream)os);
    }

    private void writeGraphEdge(String id, String source, String target, OutputStream os) throws IOException {
        String tag = StringUtils.replaceEach((String)"<edge id=\"%1\" source=\"%2\" target=\"%3\" />", (String[])new String[]{"%1", "%2", "%3"}, (String[])new String[]{id, source, target});
        IOUtils.write((String)tag, (OutputStream)os);
    }

    private void writeGraphNode(String id, String label, OutputStream os) throws IOException {
        String tag = StringUtils.replaceEach((String)"<node id=\"%1\" label=\"%2\" />", (String[])new String[]{"%1", "%2"}, (String[])new String[]{id, label});
        IOUtils.write((String)tag, (OutputStream)os);
    }

    private void writeGraphNodes(OutputStream os) throws IOException {
        IOUtils.write((String)"<nodes>", (OutputStream)os);
        for (Vertex vertex : this.graph.getVertices()) {
            String id = "" + vertex.getId().toString();
            String label = (String)vertex.getProperty(this.vertexLabelProperty);
            if (StringUtils.isBlank((CharSequence)label)) {
                label = vertex.toString();
            }
            this.writeGraphNode(id, label, os);
        }
        IOUtils.write((String)"</nodes>", (OutputStream)os);
    }
}

