/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.Location;
import org.jboss.tattletale.core.NestableArchive;
import org.jboss.tattletale.reporting.AbstractReport;
import org.jboss.tattletale.reporting.Dump;
import org.jboss.tattletale.reporting.Filter;
import org.jboss.tattletale.reporting.KeyFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EliminateJarsReport
extends AbstractReport {
    private static final String NAME = "Eliminate Jar files with different versions";
    private static final String DIRECTORY = "eliminatejars";

    public EliminateJarsReport() {
        super(DIRECTORY, 1, NAME, DIRECTORY);
    }

    @Override
    public void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.newLine());
        bw.write("  <tr>" + Dump.newLine());
        bw.write("     <th>Archive</th>" + Dump.newLine());
        bw.write("     <th>Location</th>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        boolean odd = true;
        for (Archive archive : this.archives) {
            String archiveName = archive.getName();
            int finalDot = archiveName.lastIndexOf(".");
            String extension = archiveName.substring(finalDot + 1);
            SortedSet<Location> locations = this.getLocations(archive);
            Iterator lit = locations.iterator();
            Location location2 = (Location)lit.next();
            boolean include = false;
            String version = location2.getVersion();
            boolean filtered = this.isFiltered(archive.getName());
            while (!include && lit.hasNext()) {
                location2 = (Location)lit.next();
                if (version == location2.getVersion() || version != null && version.equals(location2.getVersion())) continue;
                include = true;
                if (filtered) continue;
                this.status = 2;
            }
            if (!include) continue;
            if (odd) {
                bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
            } else {
                bw.write("  <tr class=\"roweven\">" + Dump.newLine());
            }
            bw.write("     <td><a href=\"../" + extension + "/" + archiveName + ".html\">" + archiveName + "</a></td>" + Dump.newLine());
            bw.write("     <td>");
            bw.write("       <table>" + Dump.newLine());
            for (Location location2 : locations) {
                bw.write("      <tr>" + Dump.newLine());
                bw.write("        <td>" + location2.getFilename() + "</td>" + Dump.newLine());
                if (!filtered) {
                    bw.write("        <td>");
                } else {
                    bw.write("        <td style=\"text-decoration: line-through;\">");
                }
                if (location2.getVersion() != null) {
                    bw.write(location2.getVersion());
                } else {
                    bw.write("<i>Not listed</i>");
                }
                bw.write("</td>" + Dump.newLine());
                bw.write("      </tr>" + Dump.newLine());
            }
            bw.write("       </table>" + Dump.newLine());
            bw.write("</td>" + Dump.newLine());
            bw.write("  </tr>" + Dump.newLine());
            odd = !odd;
        }
        bw.write("</table>" + Dump.newLine());
    }

    private SortedSet<Location> getLocations(Archive archive) {
        TreeSet<Location> locations = new TreeSet<Location>();
        if (archive instanceof NestableArchive) {
            NestableArchive nestableArchive = (NestableArchive)archive;
            List<Archive> subArchives = nestableArchive.getSubArchives();
            for (Archive sa : subArchives) {
                locations.addAll(this.getLocations(sa));
            }
        } else {
            locations.addAll(archive.getLocations());
        }
        return locations;
    }

    @Override
    public void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.newLine());
        bw.write(Dump.newLine());
        bw.write("<h1>Eliminate Jar files with different versions</h1>" + Dump.newLine());
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.newLine());
        bw.write("<p>" + Dump.newLine());
    }

    @Override
    protected Filter createFilter() {
        return new KeyFilter();
    }
}

