/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.container.simple;

import java.lang.annotation.Annotation;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.container.simple.EventListener;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.event.PostStartup;
import org.jboss.forge.furnace.event.PreShutdown;

public abstract class AbstractEventListener
implements EventListener {
    @Override
    public void handleEvent(Object event, Annotation ... qualifiers) {
        Addon currentAddon = SimpleContainer.getAddon(this.getClass().getClassLoader());
        if (event instanceof PostStartup) {
            PostStartup postStartup = (PostStartup)event;
            if (currentAddon.equals(postStartup.getAddon())) {
                this.handleThisPostStartup();
            } else {
                this.handleEvent(postStartup);
            }
        } else if (event instanceof PreShutdown) {
            PreShutdown preShutdown = (PreShutdown)event;
            if (currentAddon.equals(preShutdown.getAddon())) {
                this.handleThisPreShutdown();
            } else {
                this.handleEvent(preShutdown);
            }
        } else {
            this.handleCustomEvent(event, qualifiers);
        }
    }

    protected void handleThisPostStartup() {
    }

    protected void handleThisPreShutdown() {
    }

    protected void handleEvent(PreShutdown preShutdown) {
    }

    protected void handleEvent(PostStartup postStartup) {
    }

    protected void handleCustomEvent(Object event, Annotation ... qualifiers) {
    }
}

