/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.Future;
import org.jboss.forge.furnace.ContainerStatus;
import org.jboss.forge.furnace.addons.AddonCompatibilityStrategy;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.lock.LockManager;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.repositories.AddonRepositoryMode;
import org.jboss.forge.furnace.spi.ContainerLifecycleListener;
import org.jboss.forge.furnace.spi.FurnaceProvider;
import org.jboss.forge.furnace.spi.ListenerRegistration;
import org.jboss.forge.furnace.versions.Version;

public interface Furnace
extends AutoCloseable {
    public Future<Furnace> startAsync();

    public Future<Furnace> startAsync(ClassLoader var1);

    public void start();

    public void start(ClassLoader var1);

    public Furnace stop();

    public boolean isServerMode();

    public Furnace setServerMode(boolean var1);

    public AddonRegistry getAddonRegistry(AddonRepository ... var1);

    public List<AddonRepository> getRepositories();

    public AddonRepository addRepository(AddonRepositoryMode var1, File var2);

    public AddonRepository addRepository(AddonRepository var1);

    public Version getVersion();

    public ListenerRegistration<ContainerLifecycleListener> addContainerLifecycleListener(ContainerLifecycleListener var1);

    public ClassLoader getRuntimeClassLoader();

    public LockManager getLockManager();

    public ContainerStatus getStatus();

    public void setArgs(String[] var1);

    public String[] getArgs();

    public boolean isTestMode();

    public void setAddonCompatibilityStrategy(AddonCompatibilityStrategy var1);

    public AddonCompatibilityStrategy getAddonCompatibilityStrategy();

    @Override
    default public void close() {
        this.stop();
    }

    public static Furnace instance(ClassLoader loader) {
        Iterator<FurnaceProvider> iterator = ServiceLoader.load(FurnaceProvider.class, loader).iterator();
        if (iterator.hasNext()) {
            FurnaceProvider provider = iterator.next();
            return provider.getFurnace(loader);
        }
        throw new IllegalArgumentException("No Furnace container found in the  " + loader + ". This method must be called within a running Furnace Addon that references a valid Furnace Container.");
    }
}

