/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.util;

import java.util.concurrent.Callable;

public final class Callables {
    private Callables() {
    }

    public static <T> Callable<T> returning(T value) {
        return new ConstantCallable<T>(value);
    }

    public static <T> T call(Callable<T> c) {
        if (c == null) {
            return null;
        }
        try {
            return c.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error invoking Callable [c]", e);
        }
    }

    static class ConstantCallable<V>
    implements Callable<V> {
        private final V value;

        public ConstantCallable(V value) {
            this.value = value;
        }

        @Override
        public V call() {
            return this.value;
        }
    }
}

