/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.serialize.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.google.common.base.Function;
import com.thinkaurelius.titan.graphdb.database.serialize.kryo.KryoInstanceCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ThreadLocalKryos
extends ThreadLocal<Kryo>
implements KryoInstanceCache {
    private final Function<Kryo, ?> configurer;
    private final String selfID;
    private static final Logger log = LoggerFactory.getLogger(ThreadLocalKryos.class);

    public ThreadLocalKryos(Function<Kryo, ?> configurer) {
        this.configurer = configurer;
        this.selfID = String.format("0x%-8s", Integer.toHexString(this.hashCode()));
        log.debug("[{}] Finishing construction", (Object)this.selfID);
    }

    @Override
    public Kryo initialValue() {
        Kryo k = new Kryo();
        this.configurer.apply((Object)k);
        log.debug("[{}] Returning thread-local Kryo {}", (Object)this.selfID, (Object)k);
        return k;
    }

    @Override
    public void close() {
        this.remove();
        log.debug("[{}] Removed thread-local", (Object)this.selfID);
    }
}

