/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.util.system;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.attribute.Duration;
import com.thinkaurelius.titan.core.util.ReflectiveConfigOptionLoader;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigElement;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigNamespace;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ConfigurationPrinter {
    private static final String DELIM = "|";
    private static final String DELIM_PADDING = " ";
    private static final String TABLE_FOOTER_LINES = "|=====\n";
    private static boolean DELIM_AT_LINE_START = true;
    private static boolean DELIM_AT_LINE_END = false;
    private final boolean showMutability;
    private final PrintStream stream;

    public static void main(String[] args) throws FileNotFoundException, IllegalAccessException, NoSuchFieldException, ClassNotFoundException {
        ReflectiveConfigOptionLoader.INSTANCE.loadStandard(ConfigurationPrinter.class);
        if (3 != args.length) {
            System.err.println("Usage: " + ConfigurationPrinter.class.getName() + " <package.class.fieldname of a ConfigNamespace root> <output filename> <display mutabilities>");
            System.exit(-1);
        }
        ConfigNamespace root = ConfigurationPrinter.stringToNamespace(args[0]);
        PrintStream stream = new PrintStream(new FileOutputStream(args[1]));
        boolean mutability = Boolean.valueOf(args[2]);
        new ConfigurationPrinter(stream, mutability).write(root);
        stream.flush();
        stream.close();
    }

    private ConfigurationPrinter(PrintStream stream, boolean showMutability) {
        this.stream = stream;
        this.showMutability = showMutability;
    }

    private void write(ConfigNamespace root) {
        this.printNamespace(root, "");
    }

    private static ConfigNamespace stringToNamespace(String raw) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        int i = raw.lastIndexOf(".");
        String fullClassName = raw.substring(0, i);
        String fieldName = raw.substring(i + 1);
        return (ConfigNamespace)Class.forName(fullClassName).getField(fieldName).get(null);
    }

    private String getFullPath(ConfigOption<?> opt) {
        StringBuilder sb = new StringBuilder(64);
        sb.insert(0, opt.getName());
        for (ConfigNamespace parent = opt.getNamespace(); null != parent && !parent.isRoot(); parent = parent.getNamespace()) {
            if (parent.isUmbrella()) {
                sb.insert(0, "[X].");
            }
            sb.insert(0, ".");
            sb.insert(0, parent.getName());
        }
        return sb.toString();
    }

    private void printNamespace(ConfigNamespace n, String prefix) {
        String newPrefix = prefix + n.getName() + ".";
        if (n.isUmbrella()) {
            newPrefix = newPrefix + "[X].";
        }
        if (n.isRoot()) {
            newPrefix = "";
        }
        if (!Iterables.isEmpty(this.getSortedChildOptions(n))) {
            this.stream.println(this.getNamespaceSectionHeader(n, prefix));
            this.stream.println(this.getTableHeader());
            for (ConfigOption configOption : this.getSortedChildOptions(n)) {
                this.stream.println(this.getTableLineForOption(configOption, newPrefix));
            }
            this.stream.println(TABLE_FOOTER_LINES);
        }
        for (ConfigNamespace configNamespace : this.getSortedChildNamespaces(n)) {
            this.printNamespace(configNamespace, newPrefix);
        }
    }

    private String getNamespaceSectionHeader(ConfigNamespace n, String prefix) {
        String fullName = prefix + n.getName();
        if (n.isUmbrella()) {
            fullName = fullName + " *";
        }
        return "==== " + fullName + " ====\n[role=\"font16\"]\n" + n.getDescription() + "\n\n";
    }

    private List<ConfigOption<?>> getSortedChildOptions(ConfigNamespace n) {
        return this.getSortedChildren(n, new Function<ConfigElement, Boolean>(){

            public Boolean apply(ConfigElement arg0) {
                return arg0.isOption() && !((ConfigOption)arg0).isHidden();
            }
        });
    }

    private List<ConfigNamespace> getSortedChildNamespaces(ConfigNamespace n) {
        return this.getSortedChildren(n, new Function<ConfigElement, Boolean>(){

            public Boolean apply(ConfigElement arg0) {
                return arg0.isNamespace();
            }
        });
    }

    private String getTableLineForOption(ConfigOption o, String prefix) {
        ArrayList<String> colData = new ArrayList<String>(10);
        String name = prefix + o.getName();
        if (o.isDeprecated()) {
            ConfigOption<?> successor = o.getDeprecationReplacement();
            name = null == successor ? "[deprecation-warning]*Deprecated* [line-through]#" + name + "#" : "[deprecation-warning]*Deprecated.  See " + this.getFullPath(successor) + "* [line-through]#" + name + "#";
        }
        colData.add(name);
        colData.add(this.removeDelim(o.getDescription()));
        colData.add(o.getDatatype().getSimpleName());
        colData.add(this.removeDelim(this.getStringForDefaultValue(o)));
        if (this.showMutability) {
            colData.add(o.getType().toString());
        }
        String line = Joiner.on((String)" | ").join(colData);
        if (DELIM_AT_LINE_START) {
            line = "| " + line;
        }
        if (DELIM_AT_LINE_END) {
            line = line + DELIM_PADDING + DELIM;
        }
        return line;
    }

    private String getTableHeader() {
        String colWidths = "2,3,1,1";
        String colNames = "Name | Description | Datatype | Default Value";
        if (this.showMutability) {
            colWidths = colWidths + ",1";
            colNames = colNames + " | Mutability";
        }
        return "[role=\"tss-config-table\",cols=\"" + colWidths + "\",options=\"header\",width=\"100%\"]\n" + TABLE_FOOTER_LINES + "| " + colNames;
    }

    private <E> List<E> getSortedChildren(ConfigNamespace n, Function<ConfigElement, Boolean> predicate) {
        ArrayList<ConfigElement> sortedElements = new ArrayList<ConfigElement>();
        for (ConfigElement e : n.getChildren()) {
            if (!((Boolean)predicate.apply((Object)e)).booleanValue()) continue;
            sortedElements.add(e);
        }
        Collections.sort(sortedElements, new Comparator<ConfigElement>(){

            @Override
            public int compare(ConfigElement o1, ConfigElement o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return sortedElements;
    }

    private String removeDelim(String s) {
        return s.replace(DELIM, "");
    }

    private String getStringForDefaultValue(ConfigOption<?> c) {
        Object o = c.getDefaultValue();
        if (null == o) {
            return "(no default value)";
        }
        if (o instanceof Duration) {
            Duration d = (Duration)o;
            return d.getLength(TimeUnit.MILLISECONDS) + " ms";
        }
        if (o instanceof String[]) {
            return Joiner.on((String)",").join((Object[])((String[])o));
        }
        return o.toString();
    }
}

