/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.annotations.NotNull;
import com.strobel.core.StringComparator;
import com.strobel.reflection.MemberType;
import com.strobel.reflection.Type;
import com.strobel.util.EmptyArrayCache;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Modifier;

public abstract class MemberInfo
implements AnnotatedElement {
    static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    static final int ENUM_MODIFIER = 16384;
    static final int VARARGS_MODIFIER = 128;
    private String _signature;
    private String _erasedSignature;
    private String _description;
    private String _erasedDescription;
    private String _briefDescription;
    private String _simpleDescription;

    MemberInfo() {
    }

    public abstract MemberType getMemberType();

    public abstract String getName();

    public abstract Type getDeclaringType();

    public Type getReflectedType() {
        return this.getDeclaringType();
    }

    public final boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    public final boolean isNonPublic() {
        return !Modifier.isPublic(this.getModifiers());
    }

    public final boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    public final boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    public final boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public final boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public final boolean isPackagePrivate() {
        return (this.getModifiers() & 7) == 0;
    }

    public abstract int getModifiers();

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return false;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return null;
    }

    @Override
    @NotNull
    public Annotation[] getAnnotations() {
        return EMPTY_ANNOTATIONS;
    }

    @Override
    @NotNull
    public Annotation[] getDeclaredAnnotations() {
        return EMPTY_ANNOTATIONS;
    }

    @Override
    public <T extends Annotation> T getDeclaredAnnotation(Class<T> annotationClass) {
        return null;
    }

    @Override
    public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        return (Annotation[])EmptyArrayCache.fromElementType(annotationClass);
    }

    @Override
    public <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> annotationClass) {
        return (Annotation[])EmptyArrayCache.fromElementType(annotationClass);
    }

    public boolean isEquivalentTo(MemberInfo other) {
        return other == this || other != null && other.getDeclaringType() == this.getDeclaringType() && StringComparator.Ordinal.equals((Object)this.getName(), (Object)other.getName());
    }

    public String getSignature() {
        if (this._signature == null) {
            this._signature = this.appendSignature(new StringBuilder()).toString();
        }
        return this._signature;
    }

    public String getErasedSignature() {
        if (this._erasedSignature == null) {
            this._erasedSignature = this.appendErasedSignature(new StringBuilder()).toString();
        }
        return this._erasedSignature;
    }

    public String getBriefDescription() {
        if (this._briefDescription == null) {
            this._briefDescription = this.appendBriefDescription(new StringBuilder()).toString();
        }
        return this._briefDescription;
    }

    public String getDescription() {
        if (this._description == null) {
            this._description = this.appendDescription(new StringBuilder()).toString();
        }
        return this._description;
    }

    public String getErasedDescription() {
        if (this._erasedDescription == null) {
            this._erasedDescription = this.appendErasedDescription(new StringBuilder()).toString();
        }
        return this._erasedDescription;
    }

    public String getSimpleDescription() {
        if (this._simpleDescription == null) {
            this._simpleDescription = this.appendSimpleDescription(new StringBuilder()).toString();
        }
        return this._simpleDescription;
    }

    public String toString() {
        return this.getSimpleDescription();
    }

    public abstract StringBuilder appendDescription(StringBuilder var1);

    public abstract StringBuilder appendBriefDescription(StringBuilder var1);

    public abstract StringBuilder appendErasedDescription(StringBuilder var1);

    public abstract StringBuilder appendSignature(StringBuilder var1);

    public abstract StringBuilder appendErasedSignature(StringBuilder var1);

    public abstract StringBuilder appendSimpleDescription(StringBuilder var1);
}

