/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.annotations.NotNull;
import com.strobel.core.ArrayUtilities;
import com.strobel.core.ReadOnlyList;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.MemberInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class MemberList<T extends MemberInfo>
extends ReadOnlyList<T> {
    private static final MemberList<?> EMPTY = new MemberList(MemberInfo.class, new MemberInfo[0]);
    private final Class<T> _memberType;

    public static <T extends MemberInfo> MemberList<T> empty() {
        return EMPTY;
    }

    @SafeVarargs
    public MemberList(Class<T> memberType, T ... members) {
        super((Object[])members);
        this._memberType = (Class)VerifyArgument.notNull(memberType, (String)"memberType");
    }

    public MemberList(Class<T> memberType, List<? extends T> members) {
        super(memberType, (Collection)VerifyArgument.noNullElements(members, (String)"members"));
        this._memberType = memberType;
    }

    public MemberList(Class<T> memberType, T[] members, int offset, int length) {
        super((Object[])members, offset, length);
        this._memberType = (Class)VerifyArgument.notNull(memberType, (String)"memberType");
    }

    @NotNull
    public MemberList<T> subList(int fromIndex, int toIndex) {
        MemberList.subListRangeCheck((int)fromIndex, (int)toIndex, (int)this.size());
        int offset = this.getOffset() + fromIndex;
        int length = toIndex - fromIndex;
        if (length == 0) {
            return MemberList.empty();
        }
        return new MemberList(this._memberType, (MemberInfo[])this.getElements(), offset, length);
    }

    public static MemberList<?> combine(MemberList<?> ... lists) {
        if (ArrayUtilities.isNullOrEmpty(lists)) {
            return MemberList.empty();
        }
        ArrayList<MemberInfo> members = new ArrayList<MemberInfo>();
        for (MemberList<?> list : lists) {
            if (list == null) continue;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MemberInfo member = (MemberInfo)iterator.next();
                members.add(member);
            }
        }
        return new MemberList<MemberInfo>(MemberInfo.class, (List<MemberInfo>)members);
    }

    Class<T> getMemberType() {
        return this._memberType;
    }
}

