/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.core.VerifyArgument;
import com.strobel.reflection.Error;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeList;
import java.util.Iterator;

public final class TypeBindings {
    private static final TypeBindings EMPTY = new TypeBindings(TypeList.empty(), TypeList.empty());
    private final TypeList _genericParameters;
    private final TypeList _boundTypes;
    private final int _hashCode;

    private TypeBindings(TypeList genericParameters, TypeList boundTypes) {
        this._genericParameters = genericParameters;
        this._boundTypes = boundTypes;
        int parameterCount = this._genericParameters.size();
        if (parameterCount != boundTypes.size()) {
            throw Error.incorrectNumberOfTypeArguments();
        }
        for (int i = 0; i < parameterCount; ++i) {
            if (((Type)genericParameters.get(i)).isGenericParameter()) continue;
            throw new IllegalArgumentException("All types in the 'genericParameters' list must be generic parameters types.");
        }
        int hash = 1;
        Iterator iterator = boundTypes.iterator();
        while (iterator.hasNext()) {
            Type boundType = (Type)iterator.next();
            if (boundType == null) continue;
            hash = hash * 31 + boundType.hashCode();
        }
        this._hashCode = hash;
    }

    public static TypeBindings empty() {
        return EMPTY;
    }

    public static TypeBindings createUnbound(TypeList genericParameters) {
        return new TypeBindings((TypeList)((Object)VerifyArgument.noNullElements((Iterable)((Object)genericParameters), (String)"genericParameters")), genericParameters);
    }

    public static TypeBindings create(TypeList genericParameters, Type ... boundTypes) {
        return new TypeBindings((TypeList)((Object)VerifyArgument.noNullElements((Iterable)((Object)genericParameters), (String)"genericParameters")), Type.list((Type[])VerifyArgument.noNullElements((Object[])boundTypes, (String)"boundTypes")));
    }

    public static TypeBindings create(TypeList genericParameters, TypeList boundTypes) {
        return new TypeBindings((TypeList)((Object)VerifyArgument.noNullElements((Iterable)((Object)genericParameters), (String)"genericParameters")), (TypeList)((Object)VerifyArgument.noNullElements((Iterable)((Object)boundTypes), (String)"boundTypes")));
    }

    public TypeList getGenericParameters() {
        return this._genericParameters;
    }

    public TypeList getBoundTypes() {
        return this._boundTypes;
    }

    public Type getGenericParameter(int index) {
        VerifyArgument.inRange((int)0, (int)this.size(), (int)index, (String)"index");
        return (Type)this._genericParameters.get(index);
    }

    public Type getBoundType(int index) {
        VerifyArgument.inRange((int)0, (int)this.size(), (int)index, (String)"index");
        return (Type)this._boundTypes.get(index);
    }

    public boolean containsGenericParameter(Type type) {
        return type != null && this._genericParameters.contains(type);
    }

    public boolean containsBoundType(Type type) {
        return type != null && this._boundTypes.contains(type);
    }

    public TypeBindings bindingsFor(TypeList genericParameters) {
        if (((TypeList)((Object)VerifyArgument.notNull((Object)((Object)genericParameters), (String)"genericParameters"))).isEmpty()) {
            return TypeBindings.empty();
        }
        Type[] boundTypes = new Type[genericParameters.size()];
        int n = genericParameters.size();
        for (int i = 0; i < n; ++i) {
            Type genericParameter = (Type)genericParameters.get(i);
            int index = this._genericParameters.indexOf(genericParameter);
            boundTypes[i] = index == -1 ? (Type)genericParameters.get(i) : (Type)this._boundTypes.get(index);
        }
        return new TypeBindings(genericParameters, Type.list(boundTypes));
    }

    public boolean hasConcreteParameter(Type genericParameter) {
        int index = this._genericParameters.indexOf(genericParameter);
        return index != -1 && !((Type)this._boundTypes.get(index)).isGenericParameter();
    }

    public boolean hasConcreteParameters() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Type parameter = this.getBoundType(i);
            if (parameter.isGenericParameter()) continue;
            return true;
        }
        return false;
    }

    public boolean hasUnboundParameters() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Type parameter = this.getBoundType(i);
            if (!parameter.isGenericParameter()) continue;
            return true;
        }
        return false;
    }

    public boolean hasBoundParameter(Type genericParameter) {
        int index = this._genericParameters.indexOf(genericParameter);
        return index != -1 && this._boundTypes.get(index) != genericParameter;
    }

    public boolean hasBoundParameters() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Type genericParameter = this.getGenericParameter(i);
            Type parameter = this.getBoundType(i);
            if (parameter == genericParameter) continue;
            return true;
        }
        return false;
    }

    public TypeBindings withAdditionalBinding(Type genericParameter, Type typeArgument) {
        TypeList genericParameters;
        Object[] boundTypes;
        int index = this._genericParameters.indexOf(genericParameter);
        if (index == -1) {
            boundTypes = new Type[this._genericParameters.size() + 1];
            this._boundTypes.toArray(boundTypes);
            index = boundTypes.length - 1;
            Object[] genericParameterArray = new Type[boundTypes.length];
            this._genericParameters.toArray(genericParameterArray);
            genericParameterArray[index] = genericParameter;
            genericParameters = Type.list((Type[])genericParameterArray);
        } else {
            genericParameters = this._genericParameters;
            boundTypes = (Type[])this._boundTypes.toArray();
        }
        boundTypes[index] = typeArgument;
        TypeBindings results = new TypeBindings(genericParameters, Type.list((Type[])boundTypes));
        int n = boundTypes.length;
        for (int i = 0; i < n; ++i) {
            if (boundTypes[i] != genericParameter || i == index) continue;
            return results.withAdditionalBinding((Type)genericParameters.get(i), typeArgument);
        }
        return results;
    }

    public TypeBindings withAdditionalBindings(TypeBindings additionalBindings) {
        TypeBindings bindings = this;
        Iterator iterator = additionalBindings.getGenericParameters().iterator();
        while (iterator.hasNext()) {
            Type parameter = (Type)iterator.next();
            bindings = bindings.withAdditionalBinding(parameter, additionalBindings.getBoundType(parameter));
        }
        return bindings;
    }

    public TypeBindings withAdditionalParameter(Type genericParameter) {
        if (this.containsGenericParameter(genericParameter)) {
            return this;
        }
        int newParameterCount = this._genericParameters.size() + 1;
        Object[] boundTypes = new Type[newParameterCount];
        Object[] genericParameters = new Type[newParameterCount];
        this._boundTypes.toArray(boundTypes);
        this._genericParameters.toArray(genericParameters);
        genericParameters[newParameterCount - 1] = genericParameter;
        boundTypes[newParameterCount - 1] = genericParameter;
        return new TypeBindings(Type.list((Type[])genericParameters), Type.list((Type[])boundTypes));
    }

    public Type findGenericParameter(String genericParameterName) {
        int n = this._genericParameters.size();
        for (int i = 0; i < n; ++i) {
            Type parameter = (Type)this._genericParameters.get(i);
            if (!parameter.getFullName().equals(genericParameterName)) continue;
            return parameter;
        }
        return null;
    }

    public Type findBoundType(String genericParameterName) {
        int n = this._genericParameters.size();
        for (int i = 0; i < n; ++i) {
            Type parameter = (Type)this._genericParameters.get(i);
            if (!parameter.getFullName().equals(genericParameterName)) continue;
            return this.getBoundType(i);
        }
        return null;
    }

    public Type getBoundType(Type genericParameter) {
        int index = this._genericParameters.indexOf(genericParameter);
        if (index == -1) {
            throw Error.typeParameterNotDefined(genericParameter);
        }
        return this.getBoundType(index);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Type binding;
            if (i > 0) {
                sb.append(',');
            }
            if ((binding = this.getBoundType(i)) == null) {
                sb.append('<');
                sb.append(i);
                sb.append('>');
                continue;
            }
            sb = binding.appendBriefDescription(sb);
        }
        sb.append('>');
        return sb.toString();
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        int size = this.size();
        TypeBindings other = (TypeBindings)o;
        if (other._hashCode != this._hashCode) {
            return false;
        }
        if (other.size() != size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            Type parameter = this.getGenericParameter(i);
            Type otherParameter = other.getGenericParameter(i);
            if (otherParameter == null ? parameter != null : !otherParameter.equals(parameter)) {
                return false;
            }
            Type binding = this.getBoundType(i);
            Type otherBinding = other.getBoundType(i);
            if (!(otherBinding == null ? binding != null : !otherBinding.equals(binding))) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this._genericParameters.size();
    }

    public boolean isEmpty() {
        return this._genericParameters.isEmpty();
    }
}

