/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.xml.condition;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.xml.xpath.XPathExpression;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.Variables;
import org.jboss.windup.config.condition.EvaluationStrategy;
import org.jboss.windup.config.parameters.FrameContext;
import org.jboss.windup.config.parameters.FrameCreationContext;
import org.jboss.windup.config.parameters.ParameterizedGraphCondition;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.FileReferenceModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.xml.condition.XmlFileDTD;
import org.jboss.windup.rules.apps.xml.condition.XmlFileFrom;
import org.jboss.windup.rules.apps.xml.condition.XmlFileIn;
import org.jboss.windup.rules.apps.xml.condition.XmlFileNamespace;
import org.jboss.windup.rules.apps.xml.condition.XmlFileResult;
import org.jboss.windup.rules.apps.xml.condition.XmlFileXpath;
import org.jboss.windup.rules.apps.xml.condition.validators.XmlCacheValidator;
import org.jboss.windup.rules.apps.xml.condition.validators.XmlFileDtdValidator;
import org.jboss.windup.rules.apps.xml.condition.validators.XmlFileNameValidator;
import org.jboss.windup.rules.apps.xml.condition.validators.XmlFileXpathValidator;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.DefaultParameterValueStore;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterValueStore;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.util.Maps;

public class XmlFile
extends ParameterizedGraphCondition
implements XmlFileDTD,
XmlFileIn,
XmlFileNamespace,
XmlFileResult,
XmlFileXpath {
    XmlCacheValidator cacheValidator = new XmlCacheValidator();
    XmlFileNameValidator fileNameValidator = new XmlFileNameValidator();
    XmlFileDtdValidator dtdValidator = new XmlFileDtdValidator();
    XmlFileXpathValidator xpathValidator = new XmlFileXpathValidator();

    public XmlFile() {
    }

    public void setXpathResultMatch(String xpathResultMatch) {
        this.xpathValidator.setXpathResult(xpathResultMatch);
    }

    private XmlFile(String xpath) {
        this.setXpath(xpath);
    }

    public String getXpathString() {
        return this.xpathValidator.getXpathString();
    }

    public static XmlFileXpath matchesXpath(String xpath) {
        return new XmlFile(xpath);
    }

    @Override
    public XmlFileDTD andDTDPublicId(String publicIdRegex) {
        this.dtdValidator.setPublicId(publicIdRegex);
        return this;
    }

    public static XmlFileDTD withDTDSystemId(String dtdNamespace) {
        XmlFile xmlFile = new XmlFile();
        xmlFile.dtdValidator.setSystemId(dtdNamespace);
        return xmlFile;
    }

    @Override
    public XmlFileDTD andDTDSystemId(String dtdNamespace) {
        this.dtdValidator.setSystemId(dtdNamespace);
        return this;
    }

    @Override
    public ConditionBuilder as(String variable) {
        Assert.notNull((Object)variable, (String)"Variable name must not be null.");
        this.setOutputVariablesName(variable);
        return this;
    }

    @Override
    public XmlFileIn inFile(String fileName) {
        this.fileNameValidator.setFileNameRegex(fileName);
        return this;
    }

    @Override
    public XmlFileResult resultMatches(String regex) {
        this.xpathValidator.setXpathResult(regex);
        return this;
    }

    public XPathExpression getXPathExpression() {
        return this.xpathValidator.getXpathExpression();
    }

    public RegexParameterizedPatternParser getInFilePattern() {
        return this.fileNameValidator.getFileNamePattern();
    }

    public String getPublicId() {
        return this.dtdValidator.getPublicId();
    }

    public static XmlFileFrom from(String fromVariable) {
        return new XmlFileFrom(fromVariable);
    }

    public void setParameterStore(ParameterStore store) {
        this.xpathValidator.setParameterStore(store);
    }

    public Set<String> getRequiredParameterNames() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.xpathValidator.getRequiredParamaterNames());
        result.addAll(this.fileNameValidator.getRequiredParamaterNames());
        return result;
    }

    protected String getVarname() {
        return this.getOutputVariablesName();
    }

    protected boolean evaluateAndPopulateValueStores(final GraphRewrite event, final EvaluationContext context, final FrameCreationContext frameCreationContext) {
        return this.evaluate(event, context, new XmlFileEvaluationStrategy(){
            private LinkedHashMap<String, List<WindupVertexFrame>> variables;

            public void modelMatched() {
                this.variables = new LinkedHashMap();
                frameCreationContext.beginNew(this.variables);
            }

            public void modelSubmitted(WindupVertexFrame model) {
                Maps.addListValue(this.variables, (Object)XmlFile.this.getVarname(), (Object)model);
            }

            @Override
            public boolean submitValue(Parameter<?> parameter, String value) {
                ParameterValueStore valueStore = DefaultParameterValueStore.getInstance((EvaluationContext)context);
                return valueStore.submit((Rewrite)event, context, parameter, value);
            }

            public void modelSubmissionRejected() {
                if (this.variables != null) {
                    this.variables = null;
                    frameCreationContext.rollback();
                }
            }
        });
    }

    protected boolean evaluateWithValueStore(final GraphRewrite event, final EvaluationContext context, FrameContext frameContext) {
        boolean result = this.evaluate(event, context, new XmlFileEvaluationStrategy(){

            public void modelMatched() {
            }

            public void modelSubmitted(WindupVertexFrame model) {
            }

            @Override
            public boolean submitValue(Parameter<?> parameter, String value) {
                ParameterValueStore valueStore = DefaultParameterValueStore.getInstance((EvaluationContext)context);
                String existingValue = valueStore.retrieve(parameter);
                if (existingValue == null) {
                    return valueStore.submit((Rewrite)event, context, parameter, value);
                }
                return valueStore.isValid((Rewrite)event, context, parameter, value);
            }

            public void modelSubmissionRejected() {
            }
        });
        if (!result) {
            frameContext.reject();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean evaluate(GraphRewrite event, EvaluationContext context, XmlFileEvaluationStrategy evaluationStrategy) {
        try {
            ExecutionStatistics.get().begin("XmlFile.evaluate");
            this.initValidators(event, context, evaluationStrategy);
            ArrayList<WindupVertexFrame> finalResults = new ArrayList<WindupVertexFrame>();
            GraphContext graphContext = event.getGraphContext();
            Iterable<? extends WindupVertexFrame> startVertices = this.getStartingVertices(event, graphContext);
            for (WindupVertexFrame windupVertexFrame : startVertices) {
                XmlFileModel xml = this.getXmlFileModelFromVertex(windupVertexFrame);
                if (!this.xmlFilePassRestrictions(event, context, xml)) continue;
                this.registerAndSubmitResultsFor(xml, finalResults, evaluationStrategy);
            }
            this.setResults(event, this.getOutputVariablesName(), finalResults);
            boolean bl = !finalResults.isEmpty();
            return bl;
        }
        finally {
            ExecutionStatistics.get().end("XmlFile.evaluate");
        }
    }

    private void initValidators(GraphRewrite event, EvaluationContext context, XmlFileEvaluationStrategy evaluationStrategy) {
        this.xpathValidator.setEvaluationStrategy(evaluationStrategy);
        this.cacheValidator.clear();
    }

    private Iterable<? extends WindupVertexFrame> getStartingVertices(GraphRewrite event, GraphContext graphContext) {
        GraphService xmlResourceService = new GraphService(graphContext, XmlFileModel.class);
        Iterable allXmls = this.getInputVariablesName() == null || this.getInputVariablesName().isEmpty() ? xmlResourceService.findAll() : Variables.instance((GraphRewrite)event).findVariable(this.getInputVariablesName());
        return allXmls;
    }

    private void registerAndSubmitResultsFor(XmlFileModel xml, List<WindupVertexFrame> results, EvaluationStrategy evaluationStrategy) {
        List<WindupVertexFrame> xpathResults = this.xpathValidator.getAndClearResultLocations();
        if (xpathResults.isEmpty()) {
            evaluationStrategy.modelMatched();
            evaluationStrategy.modelSubmitted((WindupVertexFrame)xml);
            results.add((WindupVertexFrame)xml);
        } else {
            results.addAll(xpathResults);
        }
    }

    private XmlFileModel getXmlFileModelFromVertex(WindupVertexFrame vertexFrame) {
        XmlFileModel xml;
        if (vertexFrame instanceof FileReferenceModel) {
            xml = (XmlFileModel)((FileReferenceModel)vertexFrame).getFile();
        } else if (vertexFrame instanceof XmlFileModel) {
            xml = (XmlFileModel)vertexFrame;
        } else {
            throw new WindupException("XmlFile was called on the wrong graph type ( " + vertexFrame.toPrettyString() + ")");
        }
        return xml;
    }

    private boolean xmlFilePassRestrictions(GraphRewrite event, EvaluationContext context, XmlFileModel xml) {
        boolean validation = this.cacheValidator.isValid(event, context, xml);
        validation = validation && this.fileNameValidator.isValid(event, context, xml);
        validation = validation && this.dtdValidator.isValid(event, context, xml);
        validation = validation && this.xpathValidator.isValid(event, context, xml);
        return validation;
    }

    @Override
    public XmlFileNamespace namespace(String prefix, String url) {
        this.xpathValidator.addNamespace(prefix, url);
        return this;
    }

    public void setXpath(String xpath) {
        this.xpathValidator.setXpathString(xpath);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("XmlFile");
        if (this.getInputVariablesName() != null) {
            builder.append(".inputVariable(" + this.getInputVariablesName() + ")");
        }
        if (this.xpathValidator.getXpathString() != null) {
            builder.append(".matches(" + this.xpathValidator.getXpathString() + ")");
        }
        if (this.fileNameValidator.getFileNamePattern() != null) {
            builder.append(".inFile(" + this.fileNameValidator.getFileNamePattern().toString() + ")");
        }
        if (this.dtdValidator.getPublicId() != null) {
            builder.append(".withDTDPublicId(" + this.dtdValidator.getPublicId() + ")");
        }
        builder.append(".as(" + this.getOutputVariablesName() + ")");
        return builder.toString();
    }

    public static interface XmlFileEvaluationStrategy
    extends EvaluationStrategy {
        public boolean submitValue(Parameter<?> var1, String var2);
    }
}

