/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.xml.condition.validators;

import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.rules.apps.xml.condition.validators.XmlFileValidator;
import org.jboss.windup.rules.apps.xml.model.DoctypeMetaModel;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class XmlFileDtdValidator
implements XmlFileValidator {
    private String publicId;
    private String systemId;

    @Override
    public boolean isValid(GraphRewrite event, EvaluationContext context, XmlFileModel model) {
        if (this.publicId != null && !this.publicId.isEmpty() || this.systemId != null) {
            DoctypeMetaModel doctype = model.getDoctype();
            if (doctype == null) {
                return false;
            }
            if (!(this.publicId == null || doctype.getPublicId() != null && doctype.getPublicId().matches(this.publicId))) {
                return false;
            }
            if (!(this.systemId == null || doctype.getSystemId() != null && doctype.getSystemId().matches(this.systemId))) {
                return false;
            }
        }
        return true;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getPublicId() {
        return this.publicId;
    }
}

