/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.ElementHelper;
import java.util.HashSet;
import java.util.Set;

public class VertexHelper {
    public static boolean haveEqualNeighborhood(Vertex a, Vertex b, boolean checkIdEquality) {
        if (checkIdEquality && !ElementHelper.haveEqualIds(a, b)) {
            return false;
        }
        return ElementHelper.haveEqualProperties(a, b) && VertexHelper.haveEqualEdges(a, b, checkIdEquality);
    }

    public static boolean haveEqualEdges(Vertex a, Vertex b, boolean checkIdEquality) {
        HashSet<Edge> aEdgeSet = new HashSet<Edge>();
        for (Edge edge : a.getEdges(Direction.OUT, new String[0])) {
            aEdgeSet.add(edge);
        }
        HashSet<Edge> bEdgeSet = new HashSet<Edge>();
        for (Edge edge : b.getEdges(Direction.OUT, new String[0])) {
            bEdgeSet.add(edge);
        }
        if (!VertexHelper.hasEqualEdgeSets(aEdgeSet, bEdgeSet, checkIdEquality)) {
            return false;
        }
        aEdgeSet.clear();
        bEdgeSet.clear();
        for (Edge edge : a.getEdges(Direction.IN, new String[0])) {
            aEdgeSet.add(edge);
        }
        for (Edge edge : b.getEdges(Direction.IN, new String[0])) {
            bEdgeSet.add(edge);
        }
        return VertexHelper.hasEqualEdgeSets(aEdgeSet, bEdgeSet, checkIdEquality);
    }

    private static boolean hasEqualEdgeSets(Set<Edge> aEdgeSet, Set<Edge> bEdgeSet, boolean checkIdEquality) {
        if (aEdgeSet.size() != bEdgeSet.size()) {
            return false;
        }
        for (Edge aEdge : aEdgeSet) {
            Edge tempEdge = null;
            for (Edge bEdge : bEdgeSet) {
                if (!bEdge.getLabel().equals(aEdge.getLabel())) continue;
                if (checkIdEquality) {
                    if (!ElementHelper.haveEqualIds(aEdge, bEdge) || !ElementHelper.haveEqualIds(aEdge.getVertex(Direction.IN), bEdge.getVertex(Direction.IN)) || !ElementHelper.haveEqualIds(aEdge.getVertex(Direction.OUT), bEdge.getVertex(Direction.OUT)) || !ElementHelper.haveEqualProperties(aEdge, bEdge)) continue;
                    tempEdge = bEdge;
                    break;
                }
                if (!ElementHelper.haveEqualProperties(aEdge, bEdge)) continue;
                tempEdge = bEdge;
                break;
            }
            if (tempEdge == null) {
                return false;
            }
            bEdgeSet.remove(tempEdge);
        }
        return bEdgeSet.size() == 0;
    }
}

