/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.transform;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.transform.TransformPipe;
import com.tinkerpop.pipes.util.PipeHelper;
import java.util.Arrays;
import java.util.Iterator;

public class VerticesEdgesPipe
extends AbstractPipe<Vertex, Edge>
implements TransformPipe<Vertex, Edge> {
    protected Direction direction;
    protected String[] labels;
    protected int branchFactor;
    protected Iterator<Edge> nextEnds = PipeHelper.emptyIterator();
    private final boolean doBranchFactor;

    public VerticesEdgesPipe(Direction direction, String ... labels) {
        this(direction, Integer.MAX_VALUE, labels);
    }

    public VerticesEdgesPipe(Direction direction, int branchFactor, String ... labels) {
        this.direction = direction;
        this.branchFactor = branchFactor;
        this.labels = labels;
        this.doBranchFactor = this.branchFactor != Integer.MAX_VALUE;
    }

    public String[] getLabels() {
        return this.labels;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public int getBranchFactor() {
        return this.branchFactor;
    }

    @Override
    public void reset() {
        this.nextEnds = PipeHelper.emptyIterator();
        super.reset();
    }

    @Override
    protected Edge processNextStart() {
        while (!this.nextEnds.hasNext()) {
            this.nextEnds = this.doBranchFactor ? ((Vertex)this.starts.next()).query().direction(this.direction).labels(this.labels).limit(this.branchFactor).edges().iterator() : ((Vertex)this.starts.next()).getEdges(this.direction, this.labels).iterator();
        }
        return this.nextEnds.next();
    }

    @Override
    public String toString() {
        return PipeHelper.makePipeString(this, this.direction.name().toLowerCase(), Arrays.asList(this.labels));
    }
}

