/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.RuleProvider;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.Rule;

public class RuleProviderRegistry {
    private final List<RuleProvider> providers = new ArrayList<RuleProvider>();
    private final IdentityHashMap<RuleProvider, List<Rule>> providersToRules = new IdentityHashMap();
    private Configuration configuration;

    public static RuleProviderRegistry instance(GraphRewrite event) {
        RuleProviderRegistry instance = (RuleProviderRegistry)event.getRewriteContext().get(RuleProviderRegistry.class);
        return instance;
    }

    public void setProviders(List<RuleProvider> providers) {
        this.providers.clear();
        this.providers.addAll(providers);
    }

    public List<RuleProvider> getProviders() {
        return Collections.unmodifiableList(this.providers);
    }

    public void setRules(RuleProvider provider, List<Rule> rules) {
        this.providersToRules.put(provider, rules);
    }

    public List<Rule> getRules(RuleProvider provider) {
        List<Rule> rules = this.providersToRules.get(provider);
        if (rules == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(rules);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

