/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.tooling;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jboss.forge.furnace.util.Lists;
import org.jboss.windup.exec.WindupProcessor;
import org.jboss.windup.exec.WindupProgressMonitor;
import org.jboss.windup.exec.configuration.WindupConfiguration;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphContextFactory;
import org.jboss.windup.graph.model.LinkModel;
import org.jboss.windup.graph.model.report.IgnoredFileRegexModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.model.InlineHintModel;
import org.jboss.windup.reporting.model.source.SourceReportModel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.InlineHintService;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.reporting.service.SourceReportService;
import org.jboss.windup.rules.apps.java.model.WindupJavaConfigurationModel;
import org.jboss.windup.rules.apps.java.service.WindupJavaConfigurationService;
import org.jboss.windup.tooling.ExecutionBuilder;
import org.jboss.windup.tooling.ExecutionBuilderSetInput;
import org.jboss.windup.tooling.ExecutionBuilderSetOptions;
import org.jboss.windup.tooling.ExecutionBuilderSetOptionsAndProgressMonitor;
import org.jboss.windup.tooling.ExecutionBuilderSetOutput;
import org.jboss.windup.tooling.ExecutionResults;
import org.jboss.windup.tooling.data.Classification;
import org.jboss.windup.tooling.data.Hint;
import org.jboss.windup.tooling.data.Link;
import org.jboss.windup.tooling.data.ReportLink;
import org.jboss.windup.tooling.org.jboss.windup.tooling.data.ClassificationImpl;
import org.jboss.windup.tooling.org.jboss.windup.tooling.data.HintImpl;
import org.jboss.windup.tooling.org.jboss.windup.tooling.data.LinkImpl;
import org.jboss.windup.tooling.org.jboss.windup.tooling.data.ReportLinkImpl;
import org.jboss.windup.util.PathUtil;
import org.jboss.windup.util.exception.WindupException;

public class ExecutionBuilderImpl
implements ExecutionBuilder,
ExecutionBuilderSetInput,
ExecutionBuilderSetOutput,
ExecutionBuilderSetOptions,
ExecutionBuilderSetOptionsAndProgressMonitor {
    @Inject
    private GraphContextFactory graphContextFactory;
    @Inject
    private WindupProcessor processor;
    private Path windupHome;
    private WindupProgressMonitor progressMonitor;
    private Path input;
    private Path output;
    private Set<String> ignorePathPatterns = new HashSet<String>();
    private Set<String> includePackagePrefixSet = new HashSet<String>();
    private Set<String> excludePackagePrefixSet = new HashSet<String>();
    private Map<String, Object> options = new HashMap<String, Object>();

    public ExecutionBuilderSetInput begin(Path windupHome) {
        this.windupHome = windupHome;
        return this;
    }

    public ExecutionBuilderSetOutput setInput(Path input) {
        this.input = input;
        return this;
    }

    public ExecutionBuilderSetOptionsAndProgressMonitor setOutput(Path output) {
        this.output = output;
        return this;
    }

    public ExecutionBuilderSetOptions ignore(String ignorePattern) {
        this.ignorePathPatterns.add(ignorePattern);
        return this;
    }

    public ExecutionBuilderSetOptions includePackage(String packagePrefix) {
        this.includePackagePrefixSet.add(packagePrefix);
        return this;
    }

    public ExecutionBuilderSetOptions excludePackage(String packagePrefix) {
        this.excludePackagePrefixSet.add(packagePrefix);
        return this;
    }

    public ExecutionBuilderSetOptions setProgressMonitor(WindupProgressMonitor monitor) {
        this.progressMonitor = monitor;
        return this;
    }

    public ExecutionBuilderSetOptions setOption(String name, Object value) {
        this.options.put(name, value);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExecutionResults execute() {
        PathUtil.setWindupHome((Path)this.windupHome);
        WindupConfiguration windupConfiguration = new WindupConfiguration();
        try {
            windupConfiguration.useDefaultDirectories();
        }
        catch (IOException e) {
            throw new WindupException("Failed to configure windup due to: " + e.getMessage(), (Throwable)e);
        }
        windupConfiguration.addInputPath(this.input);
        windupConfiguration.setOutputDirectory(this.output);
        windupConfiguration.setProgressMonitor(this.progressMonitor);
        Path graphPath = this.output.resolve("graph");
        try (GraphContext graphContext = this.graphContextFactory.create(graphPath);){
            GraphService graphService = new GraphService(graphContext, IgnoredFileRegexModel.class);
            WindupJavaConfigurationService windupJavaConfigurationService = new WindupJavaConfigurationService(graphContext);
            for (String string : this.ignorePathPatterns) {
                IgnoredFileRegexModel ignored = (IgnoredFileRegexModel)graphService.create();
                ignored.setRegex(string);
                WindupJavaConfigurationModel javaCfg = WindupJavaConfigurationService.getJavaConfigurationModel((GraphContext)graphContext);
                javaCfg.addIgnoredFileRegex(ignored);
            }
            windupConfiguration.setOptionValue("packages", (Object)Lists.toList(this.includePackagePrefixSet));
            windupConfiguration.setOptionValue("excludePackages", (Object)Lists.toList(this.excludePackagePrefixSet));
            for (Map.Entry entry : this.options.entrySet()) {
                windupConfiguration.setOptionValue((String)entry.getKey(), entry.getValue());
            }
            windupConfiguration.setProgressMonitor(this.progressMonitor).setGraphContext(graphContext);
            this.processor.execute(windupConfiguration);
            final List<Classification> classifications = this.getClassifications(graphContext);
            final List<Hint> list = this.getHints(graphContext);
            final List<ReportLink> reportLinks = this.getReportLinks(graphContext);
            ExecutionResults executionResults = new ExecutionResults(){

                public Iterable<Classification> getClassifications() {
                    return classifications;
                }

                public Iterable<Hint> getHints() {
                    return list;
                }

                public Iterable<ReportLink> getReportLinks() {
                    return reportLinks;
                }
            };
            return executionResults;
        }
        catch (IOException e) {
            throw new WindupException("Failed to instantiate graph due to: " + e.getMessage(), (Throwable)e);
        }
    }

    private List<ReportLink> getReportLinks(GraphContext graphContext) {
        ArrayList<ReportLink> reportLinks = new ArrayList<ReportLink>();
        SourceReportService sourceReportService = new SourceReportService(graphContext);
        ReportService reportService = new ReportService(graphContext);
        for (SourceReportModel sourceReportModel : sourceReportService.findAll()) {
            ReportLinkImpl reportLink = new ReportLinkImpl();
            reportLink.setInputFile(sourceReportModel.getSourceFileModel().asFile());
            Path reportPath = reportService.getReportDirectory().resolve(sourceReportModel.getReportFilename());
            reportLink.setReportFile(reportPath.toFile());
            reportLinks.add(reportLink);
        }
        return reportLinks;
    }

    private List<Hint> getHints(GraphContext graphContext) {
        ArrayList<Hint> hints = new ArrayList<Hint>();
        InlineHintService hintService = new InlineHintService(graphContext);
        for (InlineHintModel hintModel : hintService.findAll()) {
            HintImpl hint = new HintImpl();
            hint.setFile(hintModel.getFile().asFile());
            hint.setTitle(hintModel.getTitle());
            hint.setHint(hintModel.getHint());
            hint.setSeverity(hintModel.getSeverity());
            hint.setEffort(hintModel.getEffort());
            hint.setColumn(hintModel.getColumnNumber());
            hint.setLineNumber(hintModel.getLineNumber());
            hint.setLength(hintModel.getLength());
            hint.setSourceSnippit(hintModel.getSourceSnippit());
            hint.setRuleID(hintModel.getRuleID());
            hint.setLinks(this.asLinks(hintModel.getLinks()));
            hints.add(hint);
        }
        return hints;
    }

    private List<Classification> getClassifications(GraphContext graphContext) {
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        ClassificationService classificationService = new ClassificationService(graphContext);
        for (ClassificationModel classificationModel : classificationService.findAll()) {
            for (FileModel fileModel : classificationModel.getFileModels()) {
                ClassificationImpl classification = new ClassificationImpl();
                classification.setClassification(classificationModel.getClassification());
                classification.setDescription(classificationModel.getDescription());
                classification.setEffort(classificationModel.getEffort());
                classification.setRuleID(classificationModel.getRuleID());
                classification.setSeverity(classificationModel.getSeverity());
                classification.setFile(fileModel.asFile());
                classification.setLinks(this.asLinks(classificationModel.getLinks()));
                classifications.add(classification);
            }
        }
        return classifications;
    }

    private List<Link> asLinks(Iterable<LinkModel> linkModels) {
        ArrayList<Link> links = new ArrayList<Link>();
        for (LinkModel linkModel : linkModels) {
            LinkImpl link = new LinkImpl();
            link.setDescription(linkModel.getDescription());
            link.setUrl(linkModel.getLink());
            links.add(link);
        }
        return links;
    }
}

