/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.tooling;

import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import javax.inject.Inject;
import org.jboss.windup.exec.WindupProcessor;
import org.jboss.windup.exec.WindupProgressMonitor;
import org.jboss.windup.graph.GraphContextFactory;
import org.jboss.windup.tooling.ExecutionBuilder;
import org.jboss.windup.tooling.ExecutionBuilderSetInput;
import org.jboss.windup.tooling.ExecutionBuilderSetOptions;
import org.jboss.windup.tooling.ExecutionBuilderSetOptionsAndProgressMonitor;
import org.jboss.windup.tooling.ExecutionBuilderSetOutput;
import org.jboss.windup.tooling.ExecutionResults;
import org.jboss.windup.tooling.WindupToolingProgressMonitor;

public class ExecutionBuilderImpl
implements ExecutionBuilder,
ExecutionBuilderSetInput,
ExecutionBuilderSetOutput,
ExecutionBuilderSetOptions,
ExecutionBuilderSetOptionsAndProgressMonitor {
    @Inject
    private GraphContextFactory graphContextFactory;
    @Inject
    private WindupProcessor processor;
    private Path windupHome;
    private WindupProgressMonitor progressMonitor;
    private Path input;
    private Path output;
    private Set<String> ignorePathPatterns = new HashSet<String>();
    private Set<String> includePackagePrefixSet = new HashSet<String>();
    private Set<String> excludePackagePrefixSet = new HashSet<String>();
    private Set<String> userRulesPathSet = new HashSet<String>();
    private Map<String, Object> options = new HashMap<String, Object>();
    private boolean skipReportsRendering;

    public boolean isSkipReportsRendering() {
        return this.skipReportsRendering;
    }

    public void setSkipReportsRendering(boolean skipReportsRendering) {
        this.skipReportsRendering = skipReportsRendering;
    }

    public ExecutionBuilderSetInput begin(Path windupHome) {
        this.windupHome = windupHome;
        return this;
    }

    public ExecutionBuilderSetOutput setInput(Path input) {
        this.input = input;
        return this;
    }

    public ExecutionBuilderSetOptionsAndProgressMonitor setOutput(Path output) {
        this.output = output;
        return this;
    }

    public ExecutionBuilderSetOptions ignore(String ignorePattern) {
        this.ignorePathPatterns.add(ignorePattern);
        return this;
    }

    public ExecutionBuilderSetOptions includePackage(String packagePrefix) {
        this.includePackagePrefixSet.add(packagePrefix);
        return this;
    }

    public ExecutionBuilderSetOptions includePackages(Collection<String> includePackagePrefixes) {
        if (includePackagePrefixes != null) {
            this.includePackagePrefixSet.addAll(includePackagePrefixes);
        }
        return this;
    }

    public ExecutionBuilderSetOptions excludePackage(String packagePrefix) {
        this.excludePackagePrefixSet.add(packagePrefix);
        return this;
    }

    public ExecutionBuilderSetOptions excludePackages(Collection<String> excludePackagePrefixes) {
        if (excludePackagePrefixes != null) {
            this.excludePackagePrefixSet.addAll(excludePackagePrefixes);
        }
        return this;
    }

    public ExecutionBuilderSetOptions setProgressMonitor(WindupProgressMonitor monitor) {
        this.progressMonitor = monitor;
        return this;
    }

    public ExecutionBuilderSetOptions sourceOnlyMode() {
        this.options.put("sourceMode", true);
        return this;
    }

    public ExecutionBuilderSetOptions skipReportGeneration() {
        this.options.put("skipReports", true);
        return this;
    }

    public ExecutionBuilderSetOptions addUserRulesPath(Path rulesPath) {
        if (rulesPath == null) {
            return this;
        }
        String pathString = rulesPath.normalize().toAbsolutePath().toString();
        this.userRulesPathSet.add(pathString);
        return this;
    }

    public ExecutionBuilderSetOptions addUserRulesPaths(Iterable<Path> rulesPaths) {
        if (rulesPaths == null) {
            return this;
        }
        for (Path rulesPath : rulesPaths) {
            this.addUserRulesPath(rulesPath);
        }
        return this;
    }

    public ExecutionBuilderSetOptions setOption(String name, Object value) {
        this.options.put(name, value);
        return this;
    }

    /*
     * Exception decompiling
     */
    public ExecutionResults execute() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private class WindupProgressLoggingHandler
    extends Handler {
        private final WindupToolingProgressMonitor monitor;

        public WindupProgressLoggingHandler(WindupToolingProgressMonitor monitor) {
            this.monitor = monitor;
        }

        @Override
        public void publish(LogRecord record) {
            if (this.monitor == null) {
                return;
            }
            this.monitor.logMessage(record);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

