/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.ws.core.utils.ResourceURL;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JBossWSEntityResolver
extends JBossEntityResolver {
    private static final Logger log = Logger.getLogger(JBossWSEntityResolver.class);

    public JBossWSEntityResolver() {
        this("META-INF/jbossws-entities.properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JBossWSEntityResolver(String entitiesResource) {
        InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(entitiesResource);
        if (is == null) {
            throw new IllegalArgumentException("Resource " + entitiesResource + " not found");
        }
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException ioe) {
            log.error((Object)("Cannot read resource: " + entitiesResource), (Throwable)ioe);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {}
        }
        if (props.size() == 0) {
            throw new IllegalArgumentException("Resource " + entitiesResource + " have no mappings defined");
        }
        String key = null;
        String val = null;
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            val = props.getProperty(key);
            JBossWSEntityResolver.registerEntity((String)key, (String)val);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource inputSource;
        if (log.isDebugEnabled()) {
            log.debug((Object)("resolveEntity: [pub=" + publicId + ",sysid=" + systemId + "]"));
        }
        if ((inputSource = super.resolveEntity(publicId, systemId)) == null) {
            inputSource = this.resolveSystemIDAsURL(systemId, log.isTraceEnabled());
        }
        if (inputSource == null) {
            log.debug((Object)("Cannot resolve entity: [pub=" + publicId + ",sysid=" + systemId + "]"));
        }
        return inputSource;
    }

    protected InputSource resolveSystemIDAsURL(String id, boolean trace) {
        InputSource inputSource;
        block11: {
            if (id == null) {
                return null;
            }
            if (trace) {
                log.trace((Object)("resolveIDAsResourceURL, id=" + id));
            }
            inputSource = null;
            try {
                InputStream ins;
                URL url;
                if (trace) {
                    log.trace((Object)"Trying to resolve id as a URL");
                }
                if (!(url = new URL(id)).getProtocol().equalsIgnoreCase("file")) {
                    log.warn((Object)("Trying to resolve id as a non-file URL: " + id));
                }
                if ((ins = new ResourceURL(url).openStream()) != null) {
                    inputSource = new InputSource(ins);
                    inputSource.setSystemId(id);
                } else {
                    log.warn((Object)("Cannot load id as URL: " + id));
                }
                if (trace) {
                    log.trace((Object)"Resolved id as a URL");
                }
            }
            catch (MalformedURLException ignored) {
                if (trace) {
                    log.trace((Object)("id is not a url: " + id), (Throwable)ignored);
                }
            }
            catch (IOException e) {
                if (!trace) break block11;
                log.trace((Object)("Failed to obtain URL.InputStream from id: " + id), (Throwable)e);
            }
        }
        return inputSource;
    }
}

