/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.test;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import junit.framework.TestCase;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.DOMWriter;
import org.jboss.wsf.test.JBossWSTestHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class JBossWSTest
extends TestCase {
    protected Logger log = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    private JBossWSTestHelper delegate = new JBossWSTestHelper();

    public JBossWSTest() {
    }

    public JBossWSTest(String name) {
        super(name);
    }

    public MBeanServerConnection getServer() throws NamingException {
        return JBossWSTestHelper.getServer();
    }

    public boolean isTargetJBoss50() {
        return this.delegate.isTargetJBoss50();
    }

    public boolean isTargetJBoss42() {
        return this.delegate.isTargetJBoss42();
    }

    public boolean isTargetJBoss40() {
        return this.delegate.isTargetJBoss40();
    }

    public boolean isIntegrationNative() {
        return this.delegate.isIntegrationNative();
    }

    public boolean isIntegrationMetro() {
        return this.delegate.isIntegrationMetro();
    }

    public boolean isIntegrationCXF() {
        return this.delegate.isIntegrationCXF();
    }

    public void deploy(String archive) throws Exception {
        this.delegate.deploy(archive);
    }

    public void undeploy(String archive) throws Exception {
        this.delegate.undeploy(archive);
    }

    public String getServerHost() {
        return JBossWSTestHelper.getServerHost();
    }

    public File getArchiveFile(String archive) {
        return this.delegate.getArchiveFile(archive);
    }

    public URL getArchiveURL(String archive) throws MalformedURLException {
        return this.delegate.getArchiveURL(archive);
    }

    public File getResourceFile(String resource) {
        return this.delegate.getResourceFile(resource);
    }

    public URL getResourceURL(String resource) throws MalformedURLException {
        return this.delegate.getResourceURL(resource);
    }

    public File createResourceFile(String filename) {
        File resDir = new File(JBossWSTestHelper.getTestResourcesDir());
        File file = new File(resDir.getAbsolutePath() + File.separator + filename);
        return file;
    }

    public File createResourceFile(File parent, String filename) {
        File file = new File(parent, filename);
        return file;
    }

    protected InitialContext getInitialContext(String clientName) throws NamingException {
        InitialContext iniCtx = new InitialContext();
        Hashtable<?, ?> env = iniCtx.getEnvironment();
        env.put("java.naming.factory.url.pkgs", "org.jboss.naming.client");
        env.put("j2ee.clientName", clientName);
        return new InitialContext(env);
    }

    protected InitialContext getInitialContext() throws NamingException {
        return this.getInitialContext("jbossws-client");
    }

    public static void assertEquals(Element expElement, Element wasElement, boolean ignoreWhitespace) {
        JBossWSTest.normalizeWhitespace(expElement, ignoreWhitespace);
        JBossWSTest.normalizeWhitespace(wasElement, ignoreWhitespace);
        String expStr = DOMWriter.printNode(expElement, false);
        String wasStr = DOMWriter.printNode(wasElement, false);
        if (!expStr.equals(wasStr)) {
            System.out.println("\nExp: " + expStr + "\nWas: " + wasStr);
            Logger.getLogger(JBossWSTest.class).error((Object)("\nExp: " + expStr + "\nWas: " + wasStr));
        }
        JBossWSTest.assertEquals((String)expStr, (String)wasStr);
    }

    public static void assertEquals(Element expElement, Element wasElement) {
        JBossWSTest.assertEquals(expElement, wasElement, false);
    }

    public static void assertEquals(Object exp, Object was) {
        if (exp instanceof Object[] && was instanceof Object[]) {
            JBossWSTest.assertEqualsArray((Object[])exp, (Object[])was);
        } else if (exp instanceof byte[] && was instanceof byte[]) {
            JBossWSTest.assertEqualsArray((byte[])exp, (byte[])was);
        } else if (exp instanceof boolean[] && was instanceof boolean[]) {
            JBossWSTest.assertEqualsArray((boolean[])exp, (boolean[])was);
        } else if (exp instanceof short[] && was instanceof short[]) {
            JBossWSTest.assertEqualsArray((short[])exp, (short[])was);
        } else if (exp instanceof int[] && was instanceof int[]) {
            JBossWSTest.assertEqualsArray((int[])exp, (int[])was);
        } else if (exp instanceof long[] && was instanceof long[]) {
            JBossWSTest.assertEqualsArray((long[])exp, (long[])was);
        } else if (exp instanceof float[] && was instanceof float[]) {
            JBossWSTest.assertEqualsArray((float[])exp, (float[])was);
        } else if (exp instanceof double[] && was instanceof double[]) {
            JBossWSTest.assertEqualsArray((double[])exp, (double[])was);
        } else {
            TestCase.assertEquals((Object)exp, (Object)was);
        }
    }

    private static void assertEqualsArray(Object[] exp, Object[] was) {
        if (exp == null && was == null) {
            return;
        }
        if (exp != null && was != null) {
            if (exp.length != was.length) {
                JBossWSTest.fail((String)("Expected <" + exp.length + "> array items, but was <" + was.length + ">"));
            } else {
                for (int i = 0; i < exp.length; ++i) {
                    Object compExp = exp[i];
                    Object compWas = was[i];
                    JBossWSTest.assertEquals(compExp, compWas);
                }
            }
        } else if (exp == null) {
            JBossWSTest.fail((String)("Expected a null array, but was: " + Arrays.asList(was)));
        } else if (was == null) {
            JBossWSTest.fail((String)("Expected " + Arrays.asList(exp) + ", but was: null"));
        }
    }

    private static void assertEqualsArray(byte[] exp, byte[] was) {
        JBossWSTest.assertTrue((String)"Arrays don't match", (boolean)Arrays.equals(exp, was));
    }

    private static void assertEqualsArray(boolean[] exp, boolean[] was) {
        JBossWSTest.assertTrue((String)"Arrays don't match", (boolean)Arrays.equals(exp, was));
    }

    private static void assertEqualsArray(short[] exp, short[] was) {
        JBossWSTest.assertTrue((String)"Arrays don't match", (boolean)Arrays.equals(exp, was));
    }

    private static void assertEqualsArray(int[] exp, int[] was) {
        JBossWSTest.assertTrue((String)"Arrays don't match", (boolean)Arrays.equals(exp, was));
    }

    private static void assertEqualsArray(long[] exp, long[] was) {
        JBossWSTest.assertTrue((String)"Arrays don't match", (boolean)Arrays.equals(exp, was));
    }

    private static void assertEqualsArray(float[] exp, float[] was) {
        JBossWSTest.assertTrue((String)"Arrays don't match", (boolean)Arrays.equals(exp, was));
    }

    private static void assertEqualsArray(double[] exp, double[] was) {
        JBossWSTest.assertTrue((String)"Arrays don't match", (boolean)Arrays.equals(exp, was));
    }

    private static void normalizeWhitespace(Element element, boolean ignoreWhitespace) {
        boolean hasChildElement = false;
        ArrayList<Node> toDetach = new ArrayList<Node>();
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String nodeValue;
            Node node = childNodes.item(i);
            if (node.getNodeType() == 3 && (nodeValue = node.getNodeValue()).trim().length() == 0) {
                toDetach.add(node);
            }
            if (node.getNodeType() != 1) continue;
            JBossWSTest.normalizeWhitespace((Element)node, ignoreWhitespace);
            hasChildElement = true;
        }
        if (hasChildElement || ignoreWhitespace) {
            for (Node whiteSpaceNode : toDetach) {
                element.removeChild(whiteSpaceNode);
            }
        }
    }
}

