/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.javax;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.jboss.logging.Logger;
import org.jboss.util.NotImplementedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaxAnnotationHelper {
    private static Logger log = Logger.getLogger(JavaxAnnotationHelper.class);
    private static final Object[] noArgs = new Object[0];

    private JavaxAnnotationHelper() {
    }

    public static void injectResources(Object instance) throws Exception {
        JavaxAnnotationHelper.injectResources(instance, Thread.currentThread().getContextClassLoader());
    }

    public static void injectResources(Object instance, ClassLoader classLoader) throws Exception {
        if (instance == null) {
            throw new IllegalArgumentException("Object instance cannot be null");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("ClassLoader cannot be null");
        }
        try {
            classLoader.loadClass("javax.annotation.Resource");
        }
        catch (Throwable th) {
            log.debug((Object)("Cannot inject resources: " + th.toString()));
            return;
        }
        Class<?> instanceClass = instance.getClass();
        if (instanceClass.isAnnotationPresent(Resource.class)) {
            throw new NotImplementedException("@Resource not implemented for: " + instanceClass.getName());
        }
        for (Field field : JavaxAnnotationHelper.getAllDeclaredFields(instanceClass)) {
            if (!field.isAnnotationPresent(Resource.class)) continue;
            throw new NotImplementedException("@Resource not implemented for: " + instanceClass.getName());
        }
        for (Method method : JavaxAnnotationHelper.getAllDeclaredMethods(instanceClass)) {
            if (!method.isAnnotationPresent(Resource.class)) continue;
            throw new NotImplementedException("@Resource not implemented for: " + instanceClass.getName());
        }
    }

    public static void callPreDestroyMethod(Object instance) throws Exception {
        JavaxAnnotationHelper.callPreDestroyMethod(instance, Thread.currentThread().getContextClassLoader());
    }

    public static void callPreDestroyMethod(Object instance, ClassLoader classLoader) throws Exception {
        if (instance == null) {
            throw new IllegalArgumentException("Object instance cannot be null");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("ClassLoader cannot be null");
        }
        try {
            classLoader.loadClass("javax.annotation.PreDestroy");
        }
        catch (Throwable th) {
            log.debug((Object)("Cannot call pre destroy: " + th.toString()));
            return;
        }
        Method targetMethod = null;
        for (Method method : JavaxAnnotationHelper.getAllDeclaredMethods(instance.getClass())) {
            if (!method.isAnnotationPresent(PreDestroy.class)) continue;
            if (targetMethod == null) {
                targetMethod = method;
                continue;
            }
            throw new RuntimeException("Only one method can be annotated with javax.annotation.PreDestroy annotation");
        }
        if (targetMethod != null) {
            JavaxAnnotationHelper.assertNoParameters(targetMethod);
            JavaxAnnotationHelper.assertVoidReturnType(targetMethod);
            JavaxAnnotationHelper.assertNoCheckedExceptionsAreThrown(targetMethod);
            JavaxAnnotationHelper.assertNotStatic(targetMethod);
            JavaxAnnotationHelper.invokeMethod(targetMethod, instance);
        }
    }

    public static void callPostConstructMethod(Object instance) throws Exception {
        JavaxAnnotationHelper.callPostConstructMethod(instance, Thread.currentThread().getContextClassLoader());
    }

    public static void callPostConstructMethod(Object instance, ClassLoader classLoader) throws Exception {
        if (instance == null) {
            throw new IllegalArgumentException("Object instance cannot be null");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("ClassLoader cannot be null");
        }
        try {
            classLoader.loadClass("javax.annotation.PostConstruct");
        }
        catch (Throwable th) {
            log.debug((Object)("Cannot call post construct: " + th.toString()));
            return;
        }
        Method targetMethod = null;
        for (Method method : JavaxAnnotationHelper.getAllDeclaredMethods(instance.getClass())) {
            if (!method.isAnnotationPresent(PostConstruct.class)) continue;
            if (targetMethod == null) {
                targetMethod = method;
                continue;
            }
            throw new RuntimeException("Only one method can be annotated with javax.annotation.PostConstruct annotation");
        }
        if (targetMethod != null) {
            JavaxAnnotationHelper.assertNoParameters(targetMethod);
            JavaxAnnotationHelper.assertVoidReturnType(targetMethod);
            JavaxAnnotationHelper.assertNoCheckedExceptionsAreThrown(targetMethod);
            JavaxAnnotationHelper.assertNotStatic(targetMethod);
            JavaxAnnotationHelper.invokeMethod(targetMethod, instance);
        }
    }

    private static List<Method> getAllDeclaredMethods(Class<?> clazz) {
        LinkedList<Method> retVal = new LinkedList<Method>();
        while (clazz != null) {
            for (Method m : clazz.getDeclaredMethods()) {
                retVal.add(m);
            }
            clazz = clazz.getSuperclass();
        }
        return retVal;
    }

    private static List<Field> getAllDeclaredFields(Class<?> clazz) {
        LinkedList<Field> retVal = new LinkedList<Field>();
        while (clazz != null) {
            for (Field f : clazz.getDeclaredFields()) {
                retVal.add(f);
            }
            clazz = clazz.getSuperclass();
        }
        return retVal;
    }

    private static void invokeMethod(Method m, Object instance) throws Exception {
        if (!m.isAccessible()) {
            m.setAccessible(true);
        }
        m.invoke(instance, noArgs);
    }

    private static void assertNoParameters(Method m) {
        if (m.getParameterTypes().length != 0) {
            throw new RuntimeException("Method annotated with javax.annotation annotations have to be parameterless");
        }
    }

    private static void assertVoidReturnType(Method m) {
        if (!m.getReturnType().equals(Void.class) && !m.getReturnType().equals(Void.TYPE)) {
            throw new RuntimeException("Method annotated with javax.annotation annotations have to return void");
        }
    }

    private static void assertNoCheckedExceptionsAreThrown(Method m) {
        Class<?>[] declaredExceptions = m.getExceptionTypes();
        for (int i = 0; i < declaredExceptions.length; ++i) {
            Class<RuntimeException> exception = declaredExceptions[i];
            if (exception.isAssignableFrom(RuntimeException.class)) continue;
            throw new RuntimeException("Method annotated with javax.annotation annotations cannot throw checked exceptions");
        }
    }

    private static void assertNotStatic(Method m) {
        if (Modifier.isStatic(m.getModifiers())) {
            throw new RuntimeException("Method annotated with javax.annotation annotations cannot be static");
        }
    }
}

