/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.ant;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseClasspathTask
extends Task {
    private String pathId;
    private String excludesFile;
    private String outputFile;
    private String srcPath;
    private String srcOutput;

    public void execute() throws BuildException {
        Project project = this.getProject();
        Path path = (Path)project.getReference(this.pathId);
        String[] pathElements = path.list();
        try {
            List<String> excludes = this.getExcludes();
            StringBuffer sb = new StringBuffer();
            this.generateContent(sb, excludes, pathElements);
            File file = this.outputFile != null ? new File(this.outputFile) : new File(this.getProject().getBaseDir(), ".classpath");
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            out.write(sb.toString());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
    }

    private void generateContent(StringBuffer sb, List<String> excludes, String[] libs) {
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<classpath>\n");
        sb.append("<classpathentry ");
        if (excludes != null && !excludes.isEmpty()) {
            sb.append("excluding=\"");
            Iterator<String> it = excludes.iterator();
            while (it.hasNext()) {
                sb.append(it.next());
                if (!it.hasNext()) continue;
                sb.append("|");
            }
            sb.append("\" ");
        }
        sb.append("kind=\"src\" ");
        if (this.srcOutput != null) {
            sb.append("output=\"");
            sb.append(this.srcOutput);
            sb.append("\" ");
        }
        if (this.srcPath != null) {
            sb.append("path=\"");
            sb.append(this.srcPath);
            sb.append("\" ");
        }
        sb.append("/>\n");
        sb.append("<classpathentry kind=\"con\" path=\"org.eclipse.jdt.launching.JRE_CONTAINER\"/>\n");
        for (int i = 0; i < libs.length; ++i) {
            if (!new File(libs[i]).exists() || !libs[i].endsWith(".jar")) continue;
            sb.append("<classpathentry kind=\"lib\" path=\"");
            sb.append(this.absoluteToRelativePath(libs[i]));
            sb.append("\"/>\n");
        }
        sb.append("<classpathentry kind=\"output\" path=\"bin\"/>\n");
        sb.append("</classpath>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getExcludes() throws IOException {
        LinkedList<String> excludes = new LinkedList<String>();
        if (this.excludesFile != null) {
            BufferedReader in = null;
            try {
                String str;
                in = new BufferedReader(new FileReader(this.excludesFile));
                while ((str = in.readLine()) != null) {
                    if (!(str.length() > 0 & !str.startsWith("#"))) continue;
                    excludes.add(str);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        return excludes;
    }

    private String absoluteToRelativePath(String absolutePath) {
        String baseDir = this.getProject().getBaseDir().toString();
        String result = absolutePath;
        if (absolutePath.startsWith(baseDir) && ((result = absolutePath.substring(baseDir.length())).startsWith("\\") || result.startsWith("/"))) {
            result = result.substring(1);
        }
        return result;
    }

    public void setPathId(String pathId) {
        this.pathId = pathId;
    }

    public void setExcludesFile(String excludesFile) {
        this.excludesFile = excludesFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    public void setSrcOutput(String srcOutput) {
        this.srcOutput = srcOutput;
    }
}

