/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.SecurityActions;

public class JBossWSDocumentBuilderFactory
extends DocumentBuilderFactory {
    private static Logger log;
    private static final String PROPERTY_NAME = "javax.xml.parsers.DocumentBuilderFactory";
    private static final boolean useJaxpProperty;
    private static Map<ClassLoader, JBossWSDocumentBuilderFactory> factoryMap;
    private final DocumentBuilderFactory delegate;
    private ThreadLocal<DocumentBuilderFactoryFields> fields = new ThreadLocal<DocumentBuilderFactoryFields>(){

        @Override
        protected DocumentBuilderFactoryFields initialValue() {
            return new DocumentBuilderFactoryFields();
        }
    };

    private JBossWSDocumentBuilderFactory(DocumentBuilderFactory delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object getAttribute(String name) throws IllegalArgumentException {
        return this.fields.get().getAttribute(name);
    }

    @Override
    public boolean getFeature(String name) throws ParserConfigurationException {
        return this.fields.get().getFeature(name);
    }

    @Override
    public synchronized DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactoryFields currentFields = this.fields.get();
        currentFields.copyTo(this.delegate);
        return this.delegate.newDocumentBuilder();
    }

    @Override
    public void setAttribute(String name, Object value) throws IllegalArgumentException {
        this.fields.get().setAttribute(name, value);
    }

    @Override
    public void setFeature(String name, boolean value) throws ParserConfigurationException {
        this.fields.get().setFeature(name, value);
    }

    @Override
    public boolean isCoalescing() {
        return this.fields.get().isCoalescing();
    }

    @Override
    public void setCoalescing(boolean coalescing) {
        this.fields.get().setCoalescing(coalescing);
    }

    @Override
    public boolean isExpandEntityReferences() {
        return this.fields.get().isExpandEntityReferences();
    }

    @Override
    public void setExpandEntityReferences(boolean expandEntityReferences) {
        this.fields.get().setExpandEntityReferences(expandEntityReferences);
    }

    @Override
    public boolean isIgnoringComments() {
        return this.fields.get().isIgnoringComments();
    }

    @Override
    public void setIgnoringComments(boolean ignoringComments) {
        this.fields.get().setIgnoringComments(ignoringComments);
    }

    @Override
    public boolean isIgnoringElementContentWhitespace() {
        return this.fields.get().isIgnoringElementContentWhitespace();
    }

    @Override
    public void setIgnoringElementContentWhitespace(boolean ignoringElementContentWhitespace) {
        this.fields.get().setIgnoringElementContentWhitespace(ignoringElementContentWhitespace);
    }

    @Override
    public boolean isNamespaceAware() {
        return this.fields.get().isNamespaceAware();
    }

    @Override
    public void setNamespaceAware(boolean namespaceAware) {
        this.fields.get().setNamespaceAware(namespaceAware);
    }

    @Override
    public Schema getSchema() {
        return this.fields.get().getSchema();
    }

    @Override
    public void setSchema(Schema schema) {
        this.fields.get().setSchema(schema);
    }

    @Override
    public boolean isValidating() {
        return this.fields.get().isValidating();
    }

    @Override
    public void setValidating(boolean validating) {
        this.fields.get().setValidating(validating);
    }

    @Override
    public boolean isXIncludeAware() {
        return this.fields.get().isXIncludeAware();
    }

    @Override
    public void setXIncludeAware(boolean includeAware) {
        this.fields.get().setXIncludeAware(includeAware);
    }

    public static synchronized JBossWSDocumentBuilderFactory newInstance() {
        if (useJaxpProperty || JBossWSDocumentBuilderFactory.getFactoryNameFromSystemProperty() != null) {
            return new JBossWSDocumentBuilderFactory(DocumentBuilderFactory.newInstance());
        }
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        JBossWSDocumentBuilderFactory factory = factoryMap.get(classLoader);
        if (factory == null) {
            factory = new JBossWSDocumentBuilderFactory(DocumentBuilderFactory.newInstance());
            factoryMap.put(classLoader, factory);
        }
        return factory;
    }

    private static String getFactoryNameFromSystemProperty() {
        PropertyAccessAction action = new PropertyAccessAction(PROPERTY_NAME);
        return (String)AccessController.doPrivileged(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        block4: {
            block5: {
                log = Logger.getLogger(JBossWSDocumentBuilderFactory.class);
                factoryMap = new WeakHashMap<ClassLoader, JBossWSDocumentBuilderFactory>();
                PrivilegedAction<Object> action = new PropertyAccessAction("java.home");
                String javaHome = (String)AccessController.doPrivileged(action);
                File jaxmFile = new File(javaHome + "/lib/jaxp.properties");
                if (!((Boolean)AccessController.doPrivileged(new PropertyFileExistAction(jaxmFile))).booleanValue()) break block5;
                String factoryName = null;
                boolean error = false;
                try {
                    action = new PropertyFileAccessAction(jaxmFile.getCanonicalPath());
                    Properties jaxmProperties = (Properties)AccessController.doPrivileged(action);
                    factoryName = jaxmProperties.getProperty(PROPERTY_NAME);
                    useJaxpProperty = error || factoryName != null;
                }
                catch (IOException e) {
                    try {
                        log.warn((Object)("Can't read " + jaxmFile));
                        error = true;
                        useJaxpProperty = error || factoryName != null;
                    }
                    catch (Throwable throwable) {
                        useJaxpProperty = error || factoryName != null;
                        throw throwable;
                    }
                    break block4;
                }
                break block4;
            }
            useJaxpProperty = false;
        }
    }

    private static class DocumentBuilderFactoryFields {
        private boolean coalescing = false;
        private boolean expandEntityReferences = true;
        private boolean ignoringComments = false;
        private boolean ignoringElementContentWhitespace = false;
        private boolean namespaceAware = false;
        private Schema schema = null;
        private boolean validating = false;
        private boolean XIncludeAware = false;
        private Map<String, Object> attributes = new HashMap<String, Object>();
        private Map<String, Boolean> features = new HashMap<String, Boolean>();

        private DocumentBuilderFactoryFields() {
        }

        public void copyTo(DocumentBuilderFactory target) throws ParserConfigurationException {
            target.setCoalescing(this.coalescing);
            target.setExpandEntityReferences(this.expandEntityReferences);
            target.setIgnoringComments(this.ignoringComments);
            target.setIgnoringElementContentWhitespace(this.ignoringElementContentWhitespace);
            target.setNamespaceAware(this.namespaceAware);
            target.setSchema(this.schema);
            target.setValidating(this.validating);
            target.setXIncludeAware(this.XIncludeAware);
            for (String key : this.attributes.keySet()) {
                target.setAttribute(key, this.attributes.get(key));
            }
            for (String key : this.features.keySet()) {
                target.setFeature(key, this.features.get(key));
            }
        }

        public Object getAttribute(String name) {
            return this.attributes.get(name);
        }

        public Boolean getFeature(String name) {
            return this.features.get(name);
        }

        public void setAttribute(String key, Object value) {
            this.attributes.put(key, value);
        }

        public void setFeature(String key, Boolean value) {
            this.features.put(key, value);
        }

        public boolean isCoalescing() {
            return this.coalescing;
        }

        public void setCoalescing(boolean coalescing) {
            this.coalescing = coalescing;
        }

        public boolean isExpandEntityReferences() {
            return this.expandEntityReferences;
        }

        public void setExpandEntityReferences(boolean expandEntityReferences) {
            this.expandEntityReferences = expandEntityReferences;
        }

        public boolean isIgnoringComments() {
            return this.ignoringComments;
        }

        public void setIgnoringComments(boolean ignoringComments) {
            this.ignoringComments = ignoringComments;
        }

        public boolean isIgnoringElementContentWhitespace() {
            return this.ignoringElementContentWhitespace;
        }

        public void setIgnoringElementContentWhitespace(boolean ignoringElementContentWhitespace) {
            this.ignoringElementContentWhitespace = ignoringElementContentWhitespace;
        }

        public boolean isNamespaceAware() {
            return this.namespaceAware;
        }

        public void setNamespaceAware(boolean namespaceAware) {
            this.namespaceAware = namespaceAware;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public void setSchema(Schema schema) {
            this.schema = schema;
        }

        public boolean isValidating() {
            return this.validating;
        }

        public void setValidating(boolean validating) {
            this.validating = validating;
        }

        public boolean isXIncludeAware() {
            return this.XIncludeAware;
        }

        public void setXIncludeAware(boolean includeAware) {
            this.XIncludeAware = includeAware;
        }
    }

    private static class PropertyFileExistAction
    implements PrivilegedAction<Object> {
        private File file;

        PropertyFileExistAction(File file) {
            this.file = file;
        }

        @Override
        public Object run() {
            return this.file.exists();
        }
    }

    private static class PropertyFileAccessAction
    implements PrivilegedAction<Object> {
        private String filename;

        PropertyFileAccessAction(String filename) {
            this.filename = filename;
        }

        @Override
        public Object run() {
            InputStream inStream = null;
            try {
                inStream = new FileInputStream(this.filename);
                Properties props = new Properties();
                props.load(inStream);
                Properties properties = props;
                return properties;
            }
            catch (IOException ex) {
                throw new SecurityException("Cannot load properties: " + this.filename, ex);
            }
            finally {
                try {
                    inStream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private static class PropertyAccessAction
    implements PrivilegedAction<Object> {
        private String name;

        PropertyAccessAction(String name) {
            this.name = name;
        }

        @Override
        public Object run() {
            return System.getProperty(this.name);
        }
    }
}

