/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.invocation;

import javax.xml.ws.WebServiceContext;
import org.jboss.wsf.common.injection.InjectionHelper;
import org.jboss.wsf.common.injection.PreDestroyHolder;
import org.jboss.wsf.common.invocation.AbstractInvocationHandlerJSE;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.Invocation;
import org.jboss.wsf.spi.invocation.InvocationContext;
import org.jboss.wsf.spi.invocation.ResourceInjector;
import org.jboss.wsf.spi.invocation.ResourceInjectorFactory;
import org.jboss.wsf.spi.metadata.injection.InjectionsMetaData;

public final class InvocationHandlerJAXWS
extends AbstractInvocationHandlerJSE {
    private final ResourceInjector wsContextInjector;

    public InvocationHandlerJAXWS() {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        ResourceInjectorFactory resourceInjectorFactory = (ResourceInjectorFactory)spiProvider.getSPI(ResourceInjectorFactory.class);
        this.wsContextInjector = resourceInjectorFactory.newResourceInjector();
    }

    @Override
    protected void onEndpointInstantiated(Endpoint endpoint, Invocation invocation) {
        InjectionsMetaData injectionsMD = (InjectionsMetaData)endpoint.getAttachment(InjectionsMetaData.class);
        Object targetBean = this.getTargetBean(invocation);
        this.log.debug((Object)("Injecting resources on JAXWS JSE endpoint: " + targetBean));
        InjectionHelper.injectResources(targetBean, injectionsMD);
        this.log.debug((Object)("Calling postConstruct method on JAXWS JSE endpoint: " + targetBean));
        InjectionHelper.callPostConstructMethod(targetBean);
        endpoint.addAttachment(PreDestroyHolder.class, (Object)new PreDestroyHolder(targetBean));
    }

    @Override
    protected void onBeforeInvocation(Invocation invocation) {
        WebServiceContext wsContext = this.getWebServiceContext(invocation);
        if (wsContext != null) {
            Object targetBean = this.getTargetBean(invocation);
            this.wsContextInjector.inject(targetBean, wsContext);
        }
    }

    @Override
    protected void onAfterInvocation(Invocation invocation) {
        WebServiceContext wsContext = this.getWebServiceContext(invocation);
        if (wsContext != null) {
            Object targetBean = this.getTargetBean(invocation);
            this.wsContextInjector.inject(targetBean, null);
        }
    }

    private WebServiceContext getWebServiceContext(Invocation invocation) {
        InvocationContext invocationContext = invocation.getInvocationContext();
        return (WebServiceContext)invocationContext.getAttachment(WebServiceContext.class);
    }

    private Object getTargetBean(Invocation invocation) {
        InvocationContext invocationContext = invocation.getInvocationContext();
        return invocationContext.getTargetBean();
    }
}

