/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.invocation;

import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.DOMWriter;
import org.jboss.wsf.common.handler.GenericSOAPHandler;
import org.jboss.wsf.framework.management.recording.RecordFactory;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.EndpointAssociation;
import org.jboss.wsf.spi.management.recording.Record;
import org.jboss.wsf.spi.management.recording.RecordGroupAssociation;
import org.jboss.wsf.spi.management.recording.RecordProcessor;
import org.w3c.dom.Node;

public class RecordingServerHandler
extends GenericSOAPHandler {
    private static Logger log = Logger.getLogger(RecordingServerHandler.class);

    @Override
    protected boolean handleInbound(MessageContext ctx) {
        Endpoint endpoint = EndpointAssociation.getEndpoint();
        if (endpoint != null && this.isRecording(endpoint)) {
            Record record = RecordFactory.newRecord();
            RecordGroupAssociation.pushGroupID((String)record.getGroupID());
            record.setDate(new Date());
            HttpServletRequest httpServletRequest = (HttpServletRequest)ctx.get((Object)"javax.xml.ws.servlet.request");
            if (httpServletRequest != null) {
                try {
                    record.setDestinationHost(new URL(httpServletRequest.getRequestURL().toString()).getHost());
                    record.setSourceHost(httpServletRequest.getRemoteHost());
                }
                catch (Exception e) {
                    log.warn((Object)("Unable to read from the http servlet request! " + e.getMessage()));
                }
            }
            record.setHeaders((Map)ctx.get((Object)"javax.xml.ws.http.request.headers"));
            record.setMessageType(Record.MessageType.INBOUND);
            record.setOperation((QName)ctx.get((Object)"javax.xml.ws.wsdl.operation"));
            boolean processEnvelope = false;
            Iterator it = endpoint.getRecordProcessors().iterator();
            while (it.hasNext() && !processEnvelope) {
                processEnvelope = ((RecordProcessor)it.next()).isProcessEnvelope();
            }
            if (processEnvelope) {
                SOAPMessageContext soapCtx = (SOAPMessageContext)ctx;
                try {
                    SOAPEnvelope soapEnv = soapCtx.getMessage().getSOAPPart().getEnvelope();
                    if (soapEnv != null) {
                        record.setEnvelope(DOMWriter.printNode((Node)soapEnv, true));
                    }
                }
                catch (SOAPException ex) {
                    log.error((Object)"Cannot trace SOAPMessage", (Throwable)ex);
                }
            }
            endpoint.processRecord(record);
        }
        return true;
    }

    @Override
    protected boolean handleOutbound(MessageContext ctx) {
        Endpoint endpoint = EndpointAssociation.getEndpoint();
        if (endpoint != null && this.isRecording(endpoint)) {
            String groupID = RecordGroupAssociation.popGroupID();
            Record record = RecordFactory.newRecord(groupID);
            record.setDate(new Date());
            record.setHeaders((Map)ctx.get((Object)"javax.xml.ws.http.response.headers"));
            record.setMessageType(Record.MessageType.OUTBOUND);
            record.setOperation((QName)ctx.get((Object)"javax.xml.ws.wsdl.operation"));
            boolean processEnvelope = false;
            Iterator it = endpoint.getRecordProcessors().iterator();
            while (it.hasNext() && !processEnvelope) {
                processEnvelope = ((RecordProcessor)it.next()).isProcessEnvelope();
            }
            if (processEnvelope) {
                SOAPMessageContext soapCtx = (SOAPMessageContext)ctx;
                try {
                    SOAPEnvelope soapEnv = soapCtx.getMessage().getSOAPPart().getEnvelope();
                    if (soapEnv != null) {
                        record.setEnvelope(DOMWriter.printNode((Node)soapEnv, true));
                    }
                }
                catch (SOAPException ex) {
                    log.error((Object)"Cannot trace SOAPMessage", (Throwable)ex);
                }
            }
            endpoint.processRecord(record);
        }
        return true;
    }

    @Override
    public boolean handleFault(MessageContext ctx) {
        return this.handleOutbound(ctx);
    }

    private boolean isRecording(Endpoint endpoint) {
        List processors = endpoint.getRecordProcessors();
        if (processors == null || processors.isEmpty()) {
            return false;
        }
        for (RecordProcessor processor : processors) {
            if (!processor.isRecording()) continue;
            return true;
        }
        return false;
    }
}

