/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import java.util.Arrays;
import java.util.List;
import org.jboss.wsf.common.integration.AbstractDeploymentAspect;
import org.jboss.wsf.spi.annotation.WebContext;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;

public class VirtualHostDeploymentAspect
extends AbstractDeploymentAspect {
    @Override
    public void start(Deployment dep) {
        if (Deployment.DeploymentType.JAXWS_EJB3.equals((Object)dep.getType())) {
            dep.getService().setVirtualHosts(this.getExplicitVirtualHosts(dep));
        }
    }

    protected List<String> getExplicitVirtualHosts(Deployment dep) {
        Object[] virtualHosts = null;
        for (Endpoint ep : dep.getService().getEndpoints()) {
            Class implClass = ep.getTargetBeanClass();
            WebContext anWebContext = implClass.getAnnotation(WebContext.class);
            if (anWebContext == null || anWebContext.virtualHosts() == null || anWebContext.virtualHosts().length <= 0) continue;
            String[] anVirtualHosts = anWebContext.virtualHosts();
            Object[] temp = new String[anVirtualHosts.length];
            System.arraycopy(anVirtualHosts, 0, temp, 0, anVirtualHosts.length);
            Arrays.sort(temp);
            if (virtualHosts == null) {
                virtualHosts = temp;
                continue;
            }
            if (Arrays.equals(virtualHosts, temp)) continue;
            throw new IllegalStateException("virtualHosts must be the same for all deployed endpoints");
        }
        if (virtualHosts != null) {
            return Arrays.asList(virtualHosts);
        }
        return null;
    }
}

