/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.serviceref;

import java.util.ResourceBundle;
import javax.naming.Referenceable;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.serviceref.ServiceRefBinder;
import org.jboss.wsf.spi.serviceref.ServiceRefBinderFactory;
import org.jboss.wsf.spi.serviceref.ServiceRefHandler;

public final class DefaultServiceRefHandler
implements ServiceRefHandler {
    private static final ResourceBundle bundle = BundleUtils.getBundle(DefaultServiceRefHandler.class);

    public Referenceable createReferenceable(UnifiedServiceRefMetaData serviceRefMD) {
        if (serviceRefMD.getVfsRoot() == null) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"VFSROOT_MUST_BE_PROVIDED", (Object[])new Object[0]));
        }
        if (serviceRefMD.getType() == null) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"SERVICE_REFERENCE_TYPE_MUST_BE_PROVIDED", (Object[])new Object[0]));
        }
        return this.getBinder(serviceRefMD.getType()).createReferenceable(serviceRefMD);
    }

    private ServiceRefBinder getBinder(ServiceRefHandler.Type type) {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        ServiceRefBinderFactory serviceRefBindingFactory = (ServiceRefBinderFactory)spiProvider.getSPI(ServiceRefBinderFactory.class);
        return serviceRefBindingFactory.newServiceRefBinder(type);
    }
}

