/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.deployment;

import java.util.LinkedList;
import java.util.List;
import javax.management.JMException;
import javax.management.MBeanServer;
import org.jboss.ws.api.monitoring.RecordProcessor;
import org.jboss.ws.common.ObjectNameFactory;
import org.jboss.ws.common.integration.AbstractDeploymentAspect;
import org.jboss.ws.common.monitoring.ManagedRecordProcessor;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;

public class EndpointRecordProcessorDeploymentAspect
extends AbstractDeploymentAspect {
    private MBeanServer mbeanServer;
    private List<RecordProcessor> processors;

    public void setProcessors(List<RecordProcessor> processors) {
        this.processors = processors;
    }

    @Override
    public void start(Deployment dep) {
        for (Endpoint ep : dep.getService().getEndpoints()) {
            LinkedList<RecordProcessor> processorList = new LinkedList<RecordProcessor>();
            if (this.processors != null) {
                for (RecordProcessor pr : this.processors) {
                    try {
                        RecordProcessor clone = (RecordProcessor)pr.clone();
                        this.registerRecordProcessor(clone, ep);
                        processorList.add(clone);
                    }
                    catch (CloneNotSupportedException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
            ep.setRecordProcessors(processorList);
        }
    }

    @Override
    public void stop(Deployment dep) {
        for (Endpoint ep : dep.getService().getEndpoints()) {
            List processors = ep.getRecordProcessors();
            for (RecordProcessor processor : processors) {
                this.unregisterRecordProcessor(processor, ep);
            }
        }
    }

    private void registerRecordProcessor(RecordProcessor processor, Endpoint ep) {
        try {
            this.mbeanServer.registerMBean(processor, ObjectNameFactory.create(ep.getName() + ",recordProcessor=" + processor.getName()));
        }
        catch (JMException ex) {
            this.log.debug((Object)("Cannot register endpoint with JMX server, trying with the default ManagedRecordProcessor: " + ex.getMessage()));
            try {
                this.mbeanServer.registerMBean(new ManagedRecordProcessor(processor), ObjectNameFactory.create(ep.getName() + ",recordProcessor=" + processor.getName()));
            }
            catch (JMException innerEx) {
                this.log.error((Object)"Cannot register endpoint with JMX server", (Throwable)innerEx);
            }
        }
    }

    private void unregisterRecordProcessor(RecordProcessor processor, Endpoint ep) {
        try {
            this.mbeanServer.unregisterMBean(ObjectNameFactory.create(ep.getName() + ",recordProcessor=" + processor.getName()));
        }
        catch (JMException ex) {
            this.log.error((Object)"Cannot unregister record processor with JMX server", (Throwable)ex);
        }
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }
}

