/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.injection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.ws.WebServiceContext;
import org.jboss.logging.Logger;
import org.jboss.ws.common.injection.InjectionException;
import org.jboss.ws.common.injection.finders.EJBFieldFinder;
import org.jboss.ws.common.injection.finders.EJBMethodFinder;
import org.jboss.ws.common.injection.finders.InjectionFieldFinder;
import org.jboss.ws.common.injection.finders.InjectionMethodFinder;
import org.jboss.ws.common.injection.finders.PostConstructMethodFinder;
import org.jboss.ws.common.injection.finders.PreDestroyMethodFinder;
import org.jboss.ws.common.injection.finders.ResourceFieldFinder;
import org.jboss.ws.common.injection.finders.ResourceMethodFinder;
import org.jboss.ws.common.reflection.ClassProcessor;
import org.jboss.wsf.spi.metadata.injection.InjectionMetaData;
import org.jboss.wsf.spi.metadata.injection.InjectionsMetaData;

public final class InjectionHelper {
    private static final Logger LOG = Logger.getLogger(InjectionHelper.class);
    private static final ClassProcessor<Method> POST_CONSTRUCT_METHOD_FINDER = new PostConstructMethodFinder();
    private static final ClassProcessor<Method> PRE_DESTROY_METHOD_FINDER = new PreDestroyMethodFinder();
    private static final ClassProcessor<Method> RESOURCE_METHOD_FINDER = new ResourceMethodFinder(WebServiceContext.class, false);
    private static final ClassProcessor<Field> RESOURCE_FIELD_FINDER = new ResourceFieldFinder(WebServiceContext.class, false);
    private static final ClassProcessor<Method> EJB_METHOD_FINDER = new EJBMethodFinder();
    private static final ClassProcessor<Field> EJB_FIELD_FINDER = new EJBFieldFinder();
    private static final ClassProcessor<Method> WEB_SERVICE_CONTEXT_METHOD_FINDER = new ResourceMethodFinder(WebServiceContext.class, true);
    private static final ClassProcessor<Field> WEB_SERVICE_CONTEXT_FIELD_FINDER = new ResourceFieldFinder(WebServiceContext.class, true);

    private InjectionHelper() {
    }

    public static void injectResources(Object instance, InjectionsMetaData injections, Context ctx) {
        if (instance == null) {
            throw new IllegalArgumentException("Object instance cannot be null");
        }
        if (injections == null) {
            return;
        }
        if (ctx == null) {
            return;
        }
        InjectionHelper.injectDescriptorAnnotatedAccessibleObjects(instance, injections, ctx);
        InjectionHelper.injectResourceAnnotatedAccessibleObjects(instance, injections, ctx);
        InjectionHelper.injectEJBAnnotatedAccessibleObjects(instance, injections);
    }

    public static void injectWebServiceContext(Object instance, WebServiceContext ctx) {
        Class<?> instanceClass = instance.getClass();
        Collection<Method> resourceAnnotatedMethods = WEB_SERVICE_CONTEXT_METHOD_FINDER.process(instanceClass);
        for (Method method : resourceAnnotatedMethods) {
            try {
                InjectionHelper.invokeMethod(instance, method, new Object[]{ctx});
            }
            catch (Exception e) {
                String message = "Cannot inject @Resource annotated method: " + method;
                InjectionException.rethrow(message, e);
            }
        }
        Collection<Field> resourceAnnotatedFields = WEB_SERVICE_CONTEXT_FIELD_FINDER.process(instanceClass);
        for (Field field : resourceAnnotatedFields) {
            try {
                InjectionHelper.setField(instance, field, ctx);
            }
            catch (Exception e) {
                String message = "Cannot inject @Resource annotated field: " + field;
                InjectionException.rethrow(message, e);
            }
        }
    }

    public static void callPostConstructMethod(Object instance) {
        if (instance == null) {
            throw new IllegalArgumentException("Object instance cannot be null");
        }
        Collection<Method> methods = POST_CONSTRUCT_METHOD_FINDER.process(instance.getClass());
        if (methods.size() > 0) {
            Method method = methods.iterator().next();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Calling @PostConstruct annotated method: " + method));
            }
            try {
                InjectionHelper.invokeMethod(instance, method, null);
            }
            catch (Exception e) {
                String message = "Calling of @PostConstruct annotated method failed: " + method;
                InjectionException.rethrow(message, e);
            }
        }
    }

    public static void callPreDestroyMethod(Object instance) {
        if (instance == null) {
            throw new IllegalArgumentException("Object instance cannot be null");
        }
        Collection<Method> methods = PRE_DESTROY_METHOD_FINDER.process(instance.getClass());
        if (methods.size() > 0) {
            Method method = methods.iterator().next();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Calling @PreDestroy annotated method: " + method));
            }
            try {
                InjectionHelper.invokeMethod(instance, method, null);
            }
            catch (Exception e) {
                String message = "Calling of @PreDestroy annotated method failed: " + method;
                InjectionException.rethrow(message, e);
            }
        }
    }

    private static void injectDescriptorAnnotatedAccessibleObjects(Object instance, InjectionsMetaData injections, Context ctx) {
        Collection injectionMDs = injections.getInjectionsMetaData(instance.getClass());
        for (InjectionMetaData injectionMD : injectionMDs) {
            String message;
            Method method = InjectionHelper.getMethod(injectionMD, instance.getClass());
            if (method != null) {
                try {
                    InjectionHelper.inject(instance, method, injectionMD.getEnvEntryName(), ctx);
                }
                catch (Exception e) {
                    message = "Cannot inject method (descriptor driven injection): " + injectionMD;
                    InjectionException.rethrow(message, e);
                }
                continue;
            }
            Field field = InjectionHelper.getField(injectionMD, instance.getClass());
            if (field != null) {
                try {
                    InjectionHelper.inject(instance, field, injectionMD.getEnvEntryName(), ctx);
                }
                catch (Exception e) {
                    String message2 = "Cannot inject field (descriptor driven injection): " + injectionMD;
                    InjectionException.rethrow(message2, e);
                }
                continue;
            }
            message = "Cannot find injection target for: " + injectionMD;
            throw new InjectionException(message);
        }
    }

    private static void injectResourceAnnotatedAccessibleObjects(Object instance, InjectionsMetaData injections, Context ctx) {
        String message;
        String jndiName;
        Collection<Field> resourceAnnotatedFields = RESOURCE_FIELD_FINDER.process(instance.getClass());
        Collection<Method> resourceAnnotatedMethods = RESOURCE_METHOD_FINDER.process(instance.getClass());
        for (Field field : resourceAnnotatedFields) {
            try {
                jndiName = injections.getResolver(Resource.class).resolve((AccessibleObject)field);
                InjectionHelper.inject(instance, field, jndiName, ctx);
            }
            catch (Exception e) {
                message = "Cannot inject field annotated with @Resource annotation: " + field;
                InjectionException.rethrow(message, e);
            }
        }
        for (Method method : resourceAnnotatedMethods) {
            try {
                jndiName = injections.getResolver(Resource.class).resolve((AccessibleObject)method);
                InjectionHelper.inject(instance, method, jndiName, ctx);
            }
            catch (Exception e) {
                message = "Cannot inject method annotated with @Resource annotation: " + method;
                InjectionException.rethrow(message, e);
            }
        }
    }

    private static void injectEJBAnnotatedAccessibleObjects(Object instance, InjectionsMetaData injections) {
        String message;
        String jndiName;
        Collection<Field> ejbAnnotatedFields = EJB_FIELD_FINDER.process(instance.getClass());
        Collection<Method> ejbAnnotatedMethods = EJB_METHOD_FINDER.process(instance.getClass());
        Context ctx = InjectionHelper.getDefaultContext();
        for (Field field : ejbAnnotatedFields) {
            try {
                jndiName = injections.getResolver(EJB.class).resolve((AccessibleObject)field);
                InjectionHelper.inject(instance, field, jndiName, ctx);
            }
            catch (Exception e) {
                message = "Cannot inject field annotated with @EJB annotation: " + field;
                InjectionException.rethrow(message, e);
            }
        }
        for (Method method : ejbAnnotatedMethods) {
            try {
                jndiName = injections.getResolver(EJB.class).resolve((AccessibleObject)method);
                InjectionHelper.inject(instance, method, jndiName, ctx);
            }
            catch (Exception e) {
                message = "Cannot inject method annotated with @EJB annotation: " + method;
                InjectionException.rethrow(message, e);
            }
        }
    }

    private static void inject(Object instance, Method method, String jndiName, Context ctx) {
        Object value = InjectionHelper.lookup(jndiName, ctx);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Injecting method: " + method));
        }
        InjectionHelper.invokeMethod(instance, method, new Object[]{value});
    }

    private static void inject(Object instance, Field field, String jndiName, Context ctx) {
        Object value = InjectionHelper.lookup(jndiName, ctx);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Injecting field: " + field));
        }
        InjectionHelper.setField(instance, field, value);
    }

    private static Object lookup(String jndiName, Context ctx) {
        Object value = null;
        try {
            value = ctx.lookup(jndiName);
        }
        catch (NamingException ne) {
            String message = "Resource '" + jndiName + "' not found";
            InjectionException.rethrow(message, ne);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invokeMethod(Object instance, Method method, Object[] args) {
        boolean accessability = method.isAccessible();
        try {
            method.setAccessible(true);
            method.invoke(instance, args);
        }
        catch (Exception e) {
            InjectionException.rethrow(e);
        }
        finally {
            method.setAccessible(accessability);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setField(Object instance, Field field, Object value) {
        boolean accessability = field.isAccessible();
        try {
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (Exception e) {
            InjectionException.rethrow(e);
        }
        finally {
            field.setAccessible(accessability);
        }
    }

    private static Method getMethod(InjectionMetaData injectionMD, Class<?> clazz) {
        Collection result = new InjectionMethodFinder(injectionMD).process(clazz);
        return result.isEmpty() ? null : (Method)result.iterator().next();
    }

    private static Field getField(InjectionMetaData injectionMD, Class<?> clazz) {
        Collection result = new InjectionFieldFinder(injectionMD).process(clazz);
        return result.isEmpty() ? null : (Field)result.iterator().next();
    }

    private static Context getDefaultContext() {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
        }
        catch (NamingException ne) {
            String message = "Cannot create default JNDI context";
            InjectionException.rethrow("Cannot create default JNDI context", ne);
        }
        return ctx;
    }
}

