/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.integration;

import org.jboss.logging.Logger;
import org.jboss.wsf.spi.deployment.Deployment;

public final class WSHelper {
    private static final Logger LOG = Logger.getLogger(WSHelper.class);

    private WSHelper() {
    }

    public static <A> A getRequiredAttachment(Deployment dep, Class<A> key) {
        Object value = dep.getAttachment(key);
        if (value == null) {
            LOG.error((Object)("Cannot find attachment in webservice deployment: " + key));
            throw new IllegalStateException();
        }
        return (A)value;
    }

    public static <A> A getOptionalAttachment(Deployment dep, Class<A> key) {
        return (A)dep.getAttachment(key);
    }

    public static boolean hasAttachment(Deployment dep, Class<?> key) {
        return WSHelper.getOptionalAttachment(dep, key) != null;
    }

    public static boolean isJaxrpcEjbDeployment(Deployment dep) {
        return Deployment.DeploymentType.JAXRPC_EJB21.equals((Object)dep.getType());
    }

    public static boolean isJaxrpcJseDeployment(Deployment dep) {
        return Deployment.DeploymentType.JAXRPC_JSE.equals((Object)dep.getType());
    }

    public static boolean isJaxwsEjbDeployment(Deployment dep) {
        return Deployment.DeploymentType.JAXWS_EJB3.equals((Object)dep.getType());
    }

    public static boolean isJaxwsJseDeployment(Deployment dep) {
        return Deployment.DeploymentType.JAXWS_JSE.equals((Object)dep.getType());
    }

    public static boolean isJseDeployment(Deployment dep) {
        boolean isJaxwsJse = WSHelper.isJaxwsJseDeployment(dep);
        boolean isJaxrpcJse = WSHelper.isJaxrpcJseDeployment(dep);
        return isJaxwsJse || isJaxrpcJse;
    }

    public static boolean isEjbDeployment(Deployment dep) {
        boolean isJaxwsEjb = WSHelper.isJaxwsEjbDeployment(dep);
        boolean isJaxrpcEjb = WSHelper.isJaxrpcEjbDeployment(dep);
        return isJaxwsEjb || isJaxrpcEjb;
    }

    public static boolean isJaxwsDeployment(Deployment dep) {
        boolean isJaxwsEjb = WSHelper.isJaxwsEjbDeployment(dep);
        boolean isJaxwsJse = WSHelper.isJaxwsJseDeployment(dep);
        return isJaxwsEjb || isJaxwsJse;
    }

    public static boolean isJaxrpcDeployment(Deployment dep) {
        boolean isJaxrpcEjb = WSHelper.isJaxrpcEjbDeployment(dep);
        boolean isJaxrpcJse = WSHelper.isJaxrpcJseDeployment(dep);
        return isJaxrpcEjb || isJaxrpcJse;
    }
}

