/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.deployment;

import java.util.ResourceBundle;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.LifecycleHandler;
import org.jboss.wsf.spi.invocation.InvocationHandler;

public class DefaultLifecycleHandler
implements LifecycleHandler {
    private static final ResourceBundle bundle = BundleUtils.getBundle(DefaultLifecycleHandler.class);
    protected final Logger log = Logger.getLogger(this.getClass());

    public void start(Endpoint ep) {
        Endpoint.EndpointState state;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Start: " + ep.getName()));
        }
        if ((state = ep.getState()) != Endpoint.EndpointState.UNDEFINED) {
            this.log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_START_ENDPOINT_IN_STATE", (Object[])new Object[]{state}));
        } else {
            InvocationHandler invHandler;
            if (ep.getEndpointMetrics() != null) {
                ep.getEndpointMetrics().start();
            }
            if ((invHandler = ep.getInvocationHandler()) == null) {
                throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"INVOCATION_HANDLER_NOT_AVAILABLE", (Object[])new Object[0]));
            }
            invHandler.init(ep);
            ep.setState(Endpoint.EndpointState.STARTED);
        }
    }

    public void stop(Endpoint ep) {
        Endpoint.EndpointState state;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Stop: " + ep.getName()));
        }
        if ((state = ep.getState()) != Endpoint.EndpointState.STARTED) {
            this.log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_STOP_ENDPOINT_IN_STATE", (Object[])new Object[]{state}));
        } else {
            if (ep.getEndpointMetrics() != null) {
                ep.getEndpointMetrics().stop();
            }
            ep.setState(Endpoint.EndpointState.STOPPED);
        }
    }
}

