/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.deployment;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.wsf.spi.deployment.ResourceResolver;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

public class ResourceResolverImpl
implements ResourceResolver {
    private static final ResourceBundle bundle = BundleUtils.getBundle(ResourceResolverImpl.class);
    private static Logger log = Logger.getLogger(ResourceResolverImpl.class);
    private UnifiedVirtualFile rootFile;
    private Collection<UnifiedVirtualFile> metadataFiles;

    public ResourceResolverImpl(UnifiedVirtualFile rootFile, Collection<UnifiedVirtualFile> metadataFiles) {
        this.rootFile = rootFile;
        this.metadataFiles = metadataFiles;
    }

    public URL resolve(String resourcePath) throws IOException {
        URL resourceURL = null;
        if (resourcePath != null && resourcePath.length() > 0) {
            UnifiedVirtualFile vfResource;
            block15: {
                if (resourcePath.startsWith("/")) {
                    resourcePath = resourcePath.substring(1);
                }
                try {
                    resourceURL = new URL(resourcePath);
                }
                catch (MalformedURLException ex) {
                    // empty catch block
                }
                if (resourceURL == null && this.rootFile != null) {
                    try {
                        vfResource = this.rootFile.findChild(resourcePath);
                        resourceURL = vfResource.toURL();
                    }
                    catch (IOException e) {
                        if (this.metadataFiles == null || this.metadataFiles.isEmpty()) {
                            throw e;
                        }
                        if (!log.isTraceEnabled()) break block15;
                        log.trace((Object)("Cannot get " + resourcePath + " from root file, trying with additional metadata files"), (Throwable)e);
                    }
                }
            }
            if (resourceURL == null && this.metadataFiles != null && !this.metadataFiles.isEmpty()) {
                vfResource = null;
                Iterator<UnifiedVirtualFile> it = this.metadataFiles.iterator();
                while (it.hasNext() && vfResource == null) {
                    UnifiedVirtualFile uvf = it.next();
                    URL wsdlUrl = uvf.toURL();
                    String wsdlPath = wsdlUrl.getPath();
                    if (wsdlPath.startsWith("/")) {
                        wsdlPath = wsdlPath.substring(1);
                    }
                    if (resourcePath.equals(wsdlPath)) {
                        vfResource = uvf;
                        continue;
                    }
                    try {
                        vfResource = uvf.findChild(resourcePath);
                    }
                    catch (IOException e) {
                        if (!log.isTraceEnabled()) continue;
                        log.trace((Object)("Cannot get " + resourcePath + " from " + uvf), (Throwable)e);
                    }
                }
                if (vfResource == null) {
                    throw new IOException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"COULD_NOT_FIND_IN_THE_ADDITIONAL_METADATAFILES", (Object[])new Object[]{resourcePath}));
                }
                resourceURL = vfResource.toURL();
            }
        }
        return resourceURL;
    }
}

