/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.deployment;

import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.ws.api.monitoring.Record;
import org.jboss.ws.api.monitoring.RecordFilter;
import org.jboss.ws.api.monitoring.RecordProcessor;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.injection.PreDestroyHolder;
import org.jboss.wsf.spi.deployment.AbstractExtensible;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.LifecycleHandler;
import org.jboss.wsf.spi.deployment.Service;
import org.jboss.wsf.spi.deployment.WSFDeploymentException;
import org.jboss.wsf.spi.invocation.InvocationHandler;
import org.jboss.wsf.spi.invocation.RequestHandler;
import org.jboss.wsf.spi.management.EndpointMetrics;
import org.jboss.wsf.spi.security.SecurityDomainContext;

public class AbstractDefaultEndpoint
extends AbstractExtensible {
    private static final ResourceBundle bundle = BundleUtils.getBundle(AbstractDefaultEndpoint.class);
    protected Service service;
    protected ObjectName name;
    protected String shortName;
    protected String urlPattern;
    protected String targetBean;
    protected Class<?> targetBeanClass;
    protected Endpoint.EndpointState state;
    protected RequestHandler requestHandler;
    protected InvocationHandler invocationHandler;
    protected LifecycleHandler lifecycleHandler;
    protected EndpointMetrics metrics;
    protected String address;
    protected List<RecordProcessor> recordProcessors = new Vector<RecordProcessor>();
    protected SecurityDomainContext securityDomainContext;
    protected Endpoint.EndpointType type;

    AbstractDefaultEndpoint(String targetBean) {
        this.targetBean = targetBean;
        this.state = Endpoint.EndpointState.UNDEFINED;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.assertEndpointSetterAccess();
        this.service = service;
    }

    public String getTargetBeanName() {
        return this.targetBean;
    }

    public void setTargetBeanName(String targetBean) {
        this.assertEndpointSetterAccess();
        this.targetBean = targetBean;
    }

    public synchronized Class<?> getTargetBeanClass() {
        if (this.targetBean == null) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"TARGET_BEAN_NOT_SET", (Object[])new Object[0]));
        }
        if (this.targetBeanClass != null) {
            return this.targetBeanClass;
        }
        ClassLoader classLoader = this.service.getDeployment().getRuntimeClassLoader();
        try {
            this.targetBeanClass = classLoader.loadClass(this.targetBean);
        }
        catch (ClassNotFoundException ex) {
            throw new WSFDeploymentException((Throwable)ex);
        }
        return this.targetBeanClass;
    }

    public ObjectName getName() {
        if (null == this.name) {
            try {
                this.name = new ObjectName("jboss.ws", "endpoint", this.targetBean);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                // empty catch block
            }
        }
        return this.name;
    }

    public void setName(ObjectName name) {
        this.assertEndpointSetterAccess();
        this.name = name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.assertEndpointSetterAccess();
        this.shortName = shortName;
    }

    public Endpoint.EndpointState getState() {
        return this.state;
    }

    public void setState(Endpoint.EndpointState state) {
        this.state = state;
    }

    public RequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public void setRequestHandler(RequestHandler handler) {
        this.assertEndpointSetterAccess();
        this.requestHandler = handler;
    }

    public LifecycleHandler getLifecycleHandler() {
        return this.lifecycleHandler;
    }

    public void setLifecycleHandler(LifecycleHandler handler) {
        this.assertEndpointSetterAccess();
        this.lifecycleHandler = handler;
    }

    public InvocationHandler getInvocationHandler() {
        return this.invocationHandler;
    }

    public void setInvocationHandler(InvocationHandler handler) {
        this.assertEndpointSetterAccess();
        this.invocationHandler = handler;
    }

    public <T> T addAttachment(Class<T> clazz, Object obj) {
        boolean isPreDestroyHolderClass = clazz.equals(PreDestroyHolder.class);
        boolean isObjectClass = clazz.equals(Object.class);
        if (!isPreDestroyHolderClass && !isObjectClass) {
            this.assertEndpointSetterAccess();
        }
        return (T)super.addAttachment(clazz, obj);
    }

    public <T> T removeAttachment(Class<T> key) {
        boolean isPreDestroyHolderClass = key.equals(PreDestroyHolder.class);
        boolean isObjectClass = key.equals(Object.class);
        if (!isPreDestroyHolderClass && !isObjectClass) {
            this.assertEndpointSetterAccess();
        }
        return (T)super.removeAttachment(key);
    }

    public void removeProperty(String key) {
        this.assertEndpointSetterAccess();
        super.removeProperty(key);
    }

    public void setProperty(String key, Object value) {
        this.assertEndpointSetterAccess();
        super.setProperty(key, value);
    }

    protected void assertEndpointSetterAccess() {
        if (this.state == Endpoint.EndpointState.STARTED) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_MODIFY_ENDPOINT_PROPERTIES_IN_STATE", (Object[])new Object[]{this.state}));
        }
    }

    public List<RecordProcessor> getRecordProcessors() {
        return this.recordProcessors;
    }

    public void setRecordProcessors(List<RecordProcessor> recordProcessors) {
        this.recordProcessors = new Vector<RecordProcessor>(recordProcessors);
    }

    public void processRecord(Record record) {
        for (RecordProcessor processor : this.recordProcessors) {
            if (!processor.isRecording()) continue;
            boolean match = true;
            if (processor.getFilters() != null) {
                Iterator it = processor.getFilters().iterator();
                while (it.hasNext() && match) {
                    match = ((RecordFilter)it.next()).match(record);
                }
            }
            if (!match) continue;
            processor.processRecord(record);
        }
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public SecurityDomainContext getSecurityDomainContext() {
        return this.securityDomainContext;
    }

    public void setSecurityDomainContext(SecurityDomainContext securityDomainContext) {
        this.securityDomainContext = securityDomainContext;
    }

    public void setType(Endpoint.EndpointType type) {
        this.type = type;
    }

    public Endpoint.EndpointType getType() {
        return this.type;
    }
}

