/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.deployment;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.jboss.ws.api.annotation.WebContext;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.integration.AbstractDeploymentAspect;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;

public class VirtualHostDeploymentAspect
extends AbstractDeploymentAspect {
    private static final ResourceBundle bundle = BundleUtils.getBundle(VirtualHostDeploymentAspect.class);

    @Override
    public void start(Deployment dep) {
        if (WSHelper.isEjbDeployment(dep) && !WSHelper.isJaxwsJseDeployment(dep)) {
            dep.getService().setVirtualHosts(this.getExplicitVirtualHosts(dep));
        }
    }

    protected List<String> getExplicitVirtualHosts(Deployment dep) {
        Object[] virtualHosts = null;
        for (Endpoint ep : dep.getService().getEndpoints()) {
            Class implClass = ep.getTargetBeanClass();
            WebContext anWebContext = implClass.getAnnotation(WebContext.class);
            if (anWebContext == null || anWebContext.virtualHosts() == null || anWebContext.virtualHosts().length <= 0) continue;
            String[] anVirtualHosts = anWebContext.virtualHosts();
            Object[] temp = new String[anVirtualHosts.length];
            System.arraycopy(anVirtualHosts, 0, temp, 0, anVirtualHosts.length);
            Arrays.sort(temp);
            if (virtualHosts == null) {
                virtualHosts = temp;
                continue;
            }
            if (Arrays.equals(virtualHosts, temp)) continue;
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"VIRTUALHOSTS_MUST_BE_THE_SAME_FOR_ALL_DEPLOYED_ENDPOINTS", (Object[])new Object[0]));
        }
        if (virtualHosts != null) {
            return Arrays.asList(virtualHosts);
        }
        return null;
    }
}

