/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.integration;

import java.util.ResourceBundle;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.EndpointTypeFilter;

public final class WSHelper {
    private static final ResourceBundle bundle = BundleUtils.getBundle(WSHelper.class);
    private static final Logger LOG = Logger.getLogger(WSHelper.class);

    private WSHelper() {
    }

    public static <A> A getRequiredAttachment(Deployment dep, Class<A> key) {
        Object value = dep.getAttachment(key);
        if (value == null) {
            LOG.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CAN_NOT_FIND_ATTACHMENT", (Object[])new Object[]{key}));
            throw new IllegalStateException();
        }
        return (A)value;
    }

    public static <A> A getOptionalAttachment(Deployment dep, Class<A> key) {
        return (A)dep.getAttachment(key);
    }

    public static boolean hasAttachment(Deployment dep, Class<?> key) {
        return WSHelper.getOptionalAttachment(dep, key) != null;
    }

    public static boolean isJaxrpcEjbDeployment(Deployment dep) {
        return dep.getService().getEndpoints(new EndpointTypeFilter(){

            public boolean accept(Endpoint.EndpointType type) {
                return type == Endpoint.EndpointType.JAXRPC_EJB21;
            }
        }).size() > 0;
    }

    public static boolean isJaxrpcJseDeployment(Deployment dep) {
        return dep.getService().getEndpoints(new EndpointTypeFilter(){

            public boolean accept(Endpoint.EndpointType type) {
                return type == Endpoint.EndpointType.JAXRPC_JSE;
            }
        }).size() > 0;
    }

    public static boolean isJaxwsEjbDeployment(Deployment dep) {
        return dep.getService().getEndpoints(new EndpointTypeFilter(){

            public boolean accept(Endpoint.EndpointType type) {
                return type == Endpoint.EndpointType.JAXWS_EJB3;
            }
        }).size() > 0;
    }

    public static boolean isJaxwsJseDeployment(Deployment dep) {
        return dep.getService().getEndpoints(new EndpointTypeFilter(){

            public boolean accept(Endpoint.EndpointType type) {
                return type == Endpoint.EndpointType.JAXWS_JSE || type == Endpoint.EndpointType.JAXWS_JMS;
            }
        }).size() > 0;
    }

    public static boolean isJseDeployment(Deployment dep) {
        boolean isJaxwsJse = WSHelper.isJaxwsJseDeployment(dep);
        boolean isJaxrpcJse = WSHelper.isJaxrpcJseDeployment(dep);
        return isJaxwsJse || isJaxrpcJse;
    }

    public static boolean isEjbDeployment(Deployment dep) {
        boolean isJaxwsEjb = WSHelper.isJaxwsEjbDeployment(dep);
        boolean isJaxrpcEjb = WSHelper.isJaxrpcEjbDeployment(dep);
        return isJaxwsEjb || isJaxrpcEjb;
    }

    public static boolean isJaxwsDeployment(Deployment dep) {
        boolean isJaxwsEjb = WSHelper.isJaxwsEjbDeployment(dep);
        boolean isJaxwsJse = WSHelper.isJaxwsJseDeployment(dep);
        return isJaxwsEjb || isJaxwsJse;
    }

    public static boolean isJaxrpcDeployment(Deployment dep) {
        boolean isJaxrpcEjb = WSHelper.isJaxrpcEjbDeployment(dep);
        boolean isJaxrpcJse = WSHelper.isJaxrpcJseDeployment(dep);
        return isJaxrpcEjb || isJaxrpcJse;
    }
}

