/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.deployment;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import org.jboss.ws.common.Loggers;
import org.jboss.ws.common.Messages;
import org.jboss.wsf.spi.deployment.ResourceResolver;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

public class ResourceResolverImpl
implements ResourceResolver {
    private UnifiedVirtualFile rootFile;
    private Collection<UnifiedVirtualFile> metadataFiles;

    public ResourceResolverImpl(UnifiedVirtualFile rootFile, Collection<UnifiedVirtualFile> metadataFiles) {
        this.rootFile = rootFile;
        this.metadataFiles = metadataFiles;
    }

    public URL resolve(String resourcePath) throws IOException {
        URL resourceURL = null;
        if (resourcePath != null && resourcePath.length() > 0) {
            UnifiedVirtualFile vfResource;
            if (resourcePath.startsWith("/")) {
                resourcePath = resourcePath.substring(1);
            }
            try {
                resourceURL = new URL(resourcePath);
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
            if (resourceURL == null && this.rootFile != null) {
                try {
                    vfResource = this.rootFile.findChild(resourcePath);
                    resourceURL = vfResource.toURL();
                }
                catch (IOException e) {
                    if (this.metadataFiles == null || this.metadataFiles.isEmpty()) {
                        throw e;
                    }
                    Loggers.ROOT_LOGGER.cannotGetRootFileTryingWithAdditionalMetaData(resourcePath);
                }
            }
            if (resourceURL == null && this.metadataFiles != null && !this.metadataFiles.isEmpty()) {
                vfResource = null;
                Iterator<UnifiedVirtualFile> it = this.metadataFiles.iterator();
                while (it.hasNext() && vfResource == null) {
                    UnifiedVirtualFile uvf = it.next();
                    URL wsdlUrl = uvf.toURL();
                    String wsdlPath = wsdlUrl.getPath();
                    if (wsdlPath.startsWith("/")) {
                        wsdlPath = wsdlPath.substring(1);
                    }
                    if (resourcePath.equals(wsdlPath)) {
                        vfResource = uvf;
                        continue;
                    }
                    try {
                        vfResource = uvf.findChild(resourcePath);
                    }
                    catch (IOException e) {
                        Loggers.ROOT_LOGGER.cannotGetRootResourceFrom(resourcePath, uvf, e);
                    }
                }
                if (vfResource == null) {
                    throw Messages.MESSAGES.cannotFindInAdditionalMetaData(resourcePath);
                }
                resourceURL = vfResource.toURL();
            }
        }
        return resourceURL;
    }
}

