/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.deployment;

import java.util.ResourceBundle;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.integration.AbstractDeploymentAspect;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.LifecycleHandler;
import org.jboss.wsf.spi.deployment.Service;

public class EndpointLifecycleDeploymentAspect
extends AbstractDeploymentAspect {
    private static final ResourceBundle bundle = BundleUtils.getBundle(EndpointLifecycleDeploymentAspect.class);

    @Override
    public void start(Deployment dep) {
        for (Endpoint ep : dep.getService().getEndpoints()) {
            this.getLifecycleHandler(ep, true).start(ep);
        }
    }

    @Override
    public void stop(Deployment dep) {
        Service service = dep.getService();
        if (service != null) {
            for (Endpoint ep : service.getEndpoints()) {
                LifecycleHandler lifecycleHandler = this.getLifecycleHandler(ep, false);
                if (lifecycleHandler == null) continue;
                lifecycleHandler.stop(ep);
            }
        }
    }

    protected LifecycleHandler getLifecycleHandler(Endpoint ep, boolean assertHandler) {
        LifecycleHandler lifecycleHandler = ep.getLifecycleHandler();
        if (lifecycleHandler == null && assertHandler) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"LIFECYCLEHANDLER_NOT_INITIALISED", (Object[])new Object[0]));
        }
        return lifecycleHandler;
    }
}

