/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.ws.common.DOMUtils;
import org.jboss.ws.common.IOUtils;
import org.jboss.ws.common.Loggers;
import org.jboss.ws.common.Messages;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.ws.common.management.AbstractServerConfig;
import org.jboss.ws.common.utils.ResourceURL;
import org.jboss.ws.common.utils.SecurityActions;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.management.ServerConfig;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractWSDLFilePublisher {
    protected ArchiveDeployment dep;
    protected String expLocation;
    protected ServerConfig serverConfig;
    private static DocumentBuilder builder;

    public AbstractWSDLFilePublisher(ArchiveDeployment dep) {
        this.dep = dep;
        this.serverConfig = (ServerConfig)dep.getAttachment(ServerConfig.class);
        if (this.serverConfig == null) {
            this.serverConfig = AbstractServerConfig.getServerIntegrationServerConfig();
        }
        this.expLocation = WSHelper.isJseDeployment((Deployment)dep) || WSHelper.isWarArchive((Deployment)dep) ? "WEB-INF/wsdl/" : "META-INF/wsdl/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized DocumentBuilder getDocumentBuilder() {
        if (builder == null) {
            ClassLoader classLoader = SecurityActions.getContextClassLoader();
            SecurityActions.setContextClassLoader(AbstractWSDLFilePublisher.class.getClassLoader());
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setNamespaceAware(true);
                factory.setExpandEntityReferences(false);
                try {
                    factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                }
                catch (ParserConfigurationException pce) {
                    Loggers.DEPLOYMENT_LOGGER.error(pce);
                }
                builder = DOMUtils.newDocumentBuilder(factory);
            }
            finally {
                SecurityActions.setContextClassLoader(classLoader);
            }
        }
        return builder;
    }

    protected void publishWsdlImports(URL parentURL, Definition parentDefinition, List<String> published) throws Exception {
        this.publishWsdlImports(parentURL, parentDefinition, published, this.expLocation);
    }

    protected void publishWsdlImports(URL parentURL, Definition parentDefinition, List<String> published, String expLocation) throws Exception {
        Iterator it = parentDefinition.getImports().values().iterator();
        while (it.hasNext()) {
            for (Import wsdlImport : (List)it.next()) {
                String locationURI = wsdlImport.getLocationURI();
                if (locationURI.startsWith("http://") || published.contains(locationURI)) continue;
                published.add(locationURI);
                String baseURI = parentURL.toExternalForm();
                URL targetURL = new URL(baseURI.substring(0, baseURI.lastIndexOf("/") + 1) + locationURI);
                File targetFile = new File(targetURL.getFile());
                this.createParentDir(targetFile);
                Definition subdef = wsdlImport.getDefinition();
                WSDLFactory wsdlFactory = WSDLFactory.newInstance();
                WSDLWriter wsdlWriter = wsdlFactory.newWSDLWriter();
                FileWriter fw = new FileWriter(targetFile);
                wsdlWriter.writeWSDL(subdef, (Writer)fw);
                fw.close();
                Loggers.DEPLOYMENT_LOGGER.wsdlImportPublishedTo(targetURL);
                this.publishWsdlImports(targetURL, subdef, published, expLocation);
                Element subdoc = DOMUtils.parse(targetURL.openStream(), AbstractWSDLFilePublisher.getDocumentBuilder());
                this.publishSchemaImports(targetURL, subdoc, published, expLocation);
            }
        }
    }

    protected void createParentDir(File targetFile) {
        File parentFile = targetFile.getParentFile();
        if (parentFile == null || !parentFile.mkdirs()) {
            // empty if block
        }
    }

    protected void publishSchemaImports(URL parentURL, Element element, List<String> published) throws Exception {
        this.publishSchemaImports(parentURL, element, published, this.expLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishSchemaImports(URL parentURL, Element element, List<String> published, String expLocation) throws Exception {
        Element childElement = AbstractWSDLFilePublisher.getFirstChildElement(element);
        while (childElement != null) {
            String ns = childElement.getNamespaceURI();
            if ("http://www.w3.org/2001/XMLSchema".equals(ns)) {
                String ln = childElement.getLocalName();
                if ("import".equals(ln) || "include".equals(ln)) {
                    String schemaLocation = childElement.getAttribute("schemaLocation");
                    if (schemaLocation.length() > 0 && !schemaLocation.startsWith("http://") && !published.contains(schemaLocation)) {
                        published.add(schemaLocation);
                        String baseURI = parentURL.toExternalForm();
                        URL xsdURL = new URL(baseURI.substring(0, baseURI.lastIndexOf("/") + 1) + schemaLocation);
                        File targetFile = new File(xsdURL.getFile());
                        this.createParentDir(targetFile);
                        String deploymentName = this.dep.getCanonicalName();
                        int index = baseURI.indexOf(deploymentName) + 1;
                        String resourcePath = baseURI.substring(index + deploymentName.length());
                        resourcePath = resourcePath.substring(0, resourcePath.lastIndexOf("/") + 1);
                        resourcePath = expLocation + resourcePath + schemaLocation;
                        while (resourcePath.indexOf("//") != -1) {
                            resourcePath = resourcePath.replace("//", "/");
                        }
                        URL resourceURL = this.dep.getResourceResolver().resolve(resourcePath);
                        InputStream is = new ResourceURL(resourceURL).openStream();
                        if (is == null) {
                            throw Messages.MESSAGES.cannotFindSchemaImportInDeployment(resourcePath, deploymentName);
                        }
                        FileOutputStream fos = null;
                        try {
                            fos = new FileOutputStream(targetFile);
                            IOUtils.copyStream(fos, is);
                        }
                        finally {
                            if (fos != null) {
                                fos.close();
                            }
                        }
                        Loggers.DEPLOYMENT_LOGGER.xmlSchemaImportPublishedTo(xsdURL);
                        Element subdoc = DOMUtils.parse(xsdURL.openStream(), AbstractWSDLFilePublisher.getDocumentBuilder());
                        this.publishSchemaImports(xsdURL, subdoc, published, expLocation);
                    }
                } else if ("schema".equals(ln)) {
                    this.publishSchemaImports(parentURL, childElement, published, expLocation);
                }
            } else if ("http://schemas.xmlsoap.org/wsdl/".equals(ns) && "types".equals(childElement.getLocalName())) {
                this.publishSchemaImports(parentURL, childElement, published, expLocation);
            }
            childElement = AbstractWSDLFilePublisher.getNextSiblingElement(childElement);
        }
    }

    private static Element getFirstChildElement(Node node) {
        Node fc = node.getFirstChild();
        Element e = null;
        if (fc != null) {
            e = fc.getNodeType() == 1 ? (Element)fc : AbstractWSDLFilePublisher.getNextSiblingElement(fc);
        }
        return e;
    }

    private static Element getNextSiblingElement(Node node) {
        Element e = null;
        for (Node nextSibling = node.getNextSibling(); e == null && nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
            if (nextSibling.getNodeType() != 1) continue;
            e = (Element)nextSibling;
        }
        return e;
    }

    public void unpublishWsdlFiles() throws IOException {
        String deploymentDir = this.dep.getParent() != null ? this.dep.getParent().getSimpleName() : this.dep.getSimpleName();
        File serviceDir = new File(this.serverConfig.getServerDataDir().getCanonicalPath() + "/wsdl/" + deploymentDir);
        this.deleteWsdlPublishDirectory(serviceDir);
    }

    protected void deleteWsdlPublishDirectory(File dir) throws IOException {
        String[] files = dir.list();
        for (int i = 0; files != null && i < files.length; ++i) {
            String fileName = files[i];
            File file = new File(dir + "/" + fileName);
            if (file.isDirectory()) {
                this.deleteWsdlPublishDirectory(file);
                continue;
            }
            if (file.delete()) continue;
            Loggers.DEPLOYMENT_LOGGER.cannotDeletePublishedWsdlDoc(file.toURI().toURL());
        }
        if (!dir.delete()) {
            Loggers.DEPLOYMENT_LOGGER.cannotDeletePublishedWsdlDoc(dir.toURI().toURL());
        }
    }
}

