/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.deployment;

import org.jboss.ws.common.integration.AbstractDeploymentAspect;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.LifecycleHandler;
import org.jboss.wsf.spi.deployment.LifecycleHandlerFactory;
import org.jboss.wsf.spi.invocation.InvocationHandler;
import org.jboss.wsf.spi.invocation.InvocationHandlerFactory;
import org.jboss.wsf.spi.invocation.InvocationType;
import org.jboss.wsf.spi.invocation.RequestHandler;
import org.jboss.wsf.spi.invocation.RequestHandlerFactory;

public class EndpointHandlerDeploymentAspect
extends AbstractDeploymentAspect {
    private SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();

    @Override
    public void start(Deployment dep) {
        RequestHandler reqHandler = this.getRequestHandler();
        LifecycleHandler lcHandler = this.getLifecycleHandler();
        for (Endpoint ep : dep.getService().getEndpoints()) {
            ep.setRequestHandler(reqHandler);
            ep.setLifecycleHandler(lcHandler);
            ep.setInvocationHandler(this.getInvocationHandler(ep));
        }
    }

    private RequestHandler getRequestHandler() {
        return ((RequestHandlerFactory)this.spiProvider.getSPI(RequestHandlerFactory.class)).getRequestHandler();
    }

    private LifecycleHandler getLifecycleHandler() {
        return ((LifecycleHandlerFactory)this.spiProvider.getSPI(LifecycleHandlerFactory.class)).getLifecycleHandler();
    }

    private InvocationHandler getInvocationHandler(Endpoint ep) {
        InvocationType invocationType = InvocationType.valueOf((String)ep.getType().toString());
        return ((InvocationHandlerFactory)this.spiProvider.getSPI(InvocationHandlerFactory.class)).newInvocationHandler(invocationType);
    }
}

