/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.deployment;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.ws.api.monitoring.Record;
import org.jboss.ws.api.monitoring.RecordFilter;
import org.jboss.ws.api.monitoring.RecordProcessor;
import org.jboss.ws.common.Messages;
import org.jboss.ws.common.injection.PreDestroyHolder;
import org.jboss.wsf.spi.deployment.AbstractExtensible;
import org.jboss.wsf.spi.deployment.EndpointState;
import org.jboss.wsf.spi.deployment.EndpointType;
import org.jboss.wsf.spi.deployment.InstanceProvider;
import org.jboss.wsf.spi.deployment.LifecycleHandler;
import org.jboss.wsf.spi.deployment.Service;
import org.jboss.wsf.spi.deployment.WSFDeploymentException;
import org.jboss.wsf.spi.invocation.InvocationHandler;
import org.jboss.wsf.spi.invocation.RequestHandler;
import org.jboss.wsf.spi.management.EndpointMetrics;
import org.jboss.wsf.spi.security.SecurityDomainContext;

public class AbstractDefaultEndpoint
extends AbstractExtensible {
    protected volatile Service service;
    protected volatile ObjectName name;
    protected volatile String shortName;
    protected volatile String urlPattern;
    protected volatile String targetBean;
    protected volatile Class<?> targetBeanClass;
    protected volatile EndpointState state;
    protected volatile EndpointType type;
    protected volatile RequestHandler requestHandler;
    protected volatile InvocationHandler invocationHandler;
    protected volatile LifecycleHandler lifecycleHandler;
    protected volatile EndpointMetrics metrics;
    protected volatile String address;
    protected volatile List<RecordProcessor> recordProcessors = new CopyOnWriteArrayList<RecordProcessor>();
    protected volatile SecurityDomainContext securityDomainContext;
    protected volatile InstanceProvider instanceProvider;

    AbstractDefaultEndpoint(String targetBean) {
        super(8, 4);
        this.targetBean = targetBean;
        this.state = EndpointState.UNDEFINED;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.assertEndpointSetterAccess();
        this.service = service;
    }

    public String getTargetBeanName() {
        return this.targetBean;
    }

    public void setTargetBeanName(String targetBean) {
        this.assertEndpointSetterAccess();
        this.targetBean = targetBean;
    }

    public synchronized Class<?> getTargetBeanClass() {
        if (this.targetBeanClass != null) {
            return this.targetBeanClass;
        }
        ClassLoader classLoader = this.service.getDeployment().getClassLoader();
        try {
            this.targetBeanClass = classLoader.loadClass(this.targetBean);
        }
        catch (ClassNotFoundException ex) {
            throw new WSFDeploymentException((Throwable)ex);
        }
        return this.targetBeanClass;
    }

    public ObjectName getName() {
        if (null == this.name) {
            try {
                this.name = new ObjectName("jboss.ws", "endpoint", this.targetBean);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                // empty catch block
            }
        }
        return this.name;
    }

    public void setName(ObjectName name) {
        this.assertEndpointSetterAccess();
        this.name = name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.assertEndpointSetterAccess();
        this.shortName = shortName;
    }

    public EndpointState getState() {
        return this.state;
    }

    public void setState(EndpointState state) {
        this.state = state;
    }

    public EndpointType getType() {
        return this.type;
    }

    public void setType(EndpointType type) {
        this.type = type;
    }

    public RequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public void setRequestHandler(RequestHandler handler) {
        this.assertEndpointSetterAccess();
        this.requestHandler = handler;
    }

    public LifecycleHandler getLifecycleHandler() {
        return this.lifecycleHandler;
    }

    public void setLifecycleHandler(LifecycleHandler handler) {
        this.assertEndpointSetterAccess();
        this.lifecycleHandler = handler;
    }

    public InvocationHandler getInvocationHandler() {
        return this.invocationHandler;
    }

    public void setInvocationHandler(InvocationHandler handler) {
        this.assertEndpointSetterAccess();
        this.invocationHandler = handler;
    }

    public <T> T addAttachment(Class<T> clazz, Object obj) {
        boolean isPreDestroyHolderClass = clazz.equals(PreDestroyHolder.class);
        boolean isObjectClass = clazz.equals(Object.class);
        if (!isPreDestroyHolderClass && !isObjectClass) {
            this.assertEndpointSetterAccess();
        }
        return (T)super.addAttachment(clazz, obj);
    }

    public <T> T removeAttachment(Class<T> key) {
        boolean isPreDestroyHolderClass = key.equals(PreDestroyHolder.class);
        boolean isObjectClass = key.equals(Object.class);
        if (!isPreDestroyHolderClass && !isObjectClass) {
            this.assertEndpointSetterAccess();
        }
        return (T)super.removeAttachment(key);
    }

    public void removeProperty(String key) {
        this.assertEndpointSetterAccess();
        super.removeProperty(key);
    }

    public void setProperty(String key, Object value) {
        this.assertEndpointSetterAccess();
        super.setProperty(key, value);
    }

    protected void assertEndpointSetterAccess() {
        if (this.state == EndpointState.STARTED) {
            throw Messages.MESSAGES.cannotModifyEndpointInState(this.state, this.getName());
        }
    }

    public List<RecordProcessor> getRecordProcessors() {
        return this.recordProcessors;
    }

    public void setRecordProcessors(List<RecordProcessor> recordProcessors) {
        this.recordProcessors = new CopyOnWriteArrayList<RecordProcessor>(recordProcessors);
    }

    public void processRecord(Record record) {
        for (RecordProcessor processor : this.recordProcessors) {
            if (!processor.isRecording()) continue;
            boolean match = true;
            if (processor.getFilters() != null) {
                Iterator it = processor.getFilters().iterator();
                while (it.hasNext() && match) {
                    match = ((RecordFilter)it.next()).match(record);
                }
            }
            if (!match) continue;
            processor.processRecord(record);
        }
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public SecurityDomainContext getSecurityDomainContext() {
        return this.securityDomainContext;
    }

    public void setSecurityDomainContext(SecurityDomainContext securityDomainContext) {
        this.securityDomainContext = securityDomainContext;
    }

    public InstanceProvider getInstanceProvider() {
        return this.instanceProvider;
    }

    public void setInstanceProvider(InstanceProvider instanceProvider) {
        this.assertEndpointSetterAccess();
        this.instanceProvider = instanceProvider;
    }
}

