package org.jboss.ws.common;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import java.net.URL;
import javax.management.ObjectName;
import org.jboss.wsf.spi.deployment.EndpointState;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.ClassLoader;
import java.lang.Class;
import java.lang.Object;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2023-06-21T10:22:53+0800")
public class Loggers_$logger extends DelegatingBasicLogger implements Loggers, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Loggers_$logger.class.getName();
    public Loggers_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void cannotGetChildrenForResource(final Throwable cause, final URL url) {
        super.log.logf(FQCN, ERROR, cause, cannotGetChildrenForResource$str(), url);
    }
    protected String cannotGetChildrenForResource$str() {
        return "JBWS022001: Cannot get children for resource %s";
    }
    @Override
    public final void cannotGetNameForResource(final Throwable cause, final URL url) {
        super.log.logf(FQCN, ERROR, cause, cannotGetNameForResource$str(), url);
    }
    protected String cannotGetNameForResource$str() {
        return "JBWS022002: Cannot get name for resource %s";
    }
    @Override
    public final void notAssignableDueToConflictingClassLoaders(final Class<?> dest, final Class<?> src, final ClassLoader destClassLoader, final ClassLoader srcClassLoader) {
        super.log.logf(FQCN, TRACE, null, notAssignableDueToConflictingClassLoaders$str(), dest, src, destClassLoader, srcClassLoader);
    }
    protected String notAssignableDueToConflictingClassLoaders$str() {
        return "JBWS022010: Class %s is not assignable from %s due to conflicting classloaders: %s and %s";
    }
    @Override
    public final void couldNotClearBlacklist(final ClassLoader cl, final Throwable cause) {
        super.log.logf(FQCN, TRACE, cause, couldNotClearBlacklist$str(), cl);
    }
    protected String couldNotClearBlacklist$str() {
        return "JBWS022011: Could not clear blacklist for classloader %s";
    }
    @Override
    public final void couldNotLoad(final String className) {
        super.log.logf(FQCN, DEBUG, null, couldNotLoad$str(), className);
    }
    protected String couldNotLoad$str() {
        return "JBWS022012: Could not load %s";
    }
    @Override
    public final void cannotParse(final String s) {
        super.log.logf(FQCN, ERROR, null, cannotParse$str(), s);
    }
    protected String cannotParse$str() {
        return "JBWS022013: Cannot parse: %s";
    }
    @Override
    public final void cannotReadResource(final String s, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, cannotReadResource$str(), s);
    }
    protected String cannotReadResource$str() {
        return "JBWS022021: Cannot read resource: %s";
    }
    @Override
    public final void cannotLoadIDAsURL(final String id, final String protocol) {
        super.log.logf(FQCN, WARN, null, cannotLoadIDAsURL$str(), id, protocol);
    }
    protected String cannotLoadIDAsURL$str() {
        return "JBWS022022: Cannot load ID '%s' as URL (protocol = %s)";
    }
    @Override
    public final void wsdlImportPublishedTo(final URL url) {
        super.log.logf(FQCN, DEBUG, null, wsdlImportPublishedTo$str(), url);
    }
    protected String wsdlImportPublishedTo$str() {
        return "JBWS022025: WSDL import published to %s";
    }
    @Override
    public final void xmlSchemaImportPublishedTo(final URL url) {
        super.log.logf(FQCN, DEBUG, null, xmlSchemaImportPublishedTo$str(), url);
    }
    protected String xmlSchemaImportPublishedTo$str() {
        return "JBWS022026: XMLSchema import published to %s";
    }
    @Override
    public final void cannotDeletePublishedWsdlDoc(final URL url) {
        super.log.logf(FQCN, WARN, null, cannotDeletePublishedWsdlDoc$str(), url);
    }
    protected String cannotDeletePublishedWsdlDoc$str() {
        return "JBWS022027: Cannot delete published wsdl document: %s";
    }
    @Override
    public final void cannotRegisterProvidedProcessor(final ObjectName processorName, final Throwable cause) {
        super.log.logf(FQCN, DEBUG, cause, cannotRegisterProvidedProcessor$str(), processorName);
    }
    protected String cannotRegisterProvidedProcessor$str() {
        return "JBWS022042: Cannot register processor %s with JMX server, will be trying using the default managed implementation. ";
    }
    @Override
    public final void cannotRegisterProcessorWithJmxServer(final ObjectName processorName, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, cannotRegisterProcessorWithJmxServer$str(), processorName);
    }
    protected String cannotRegisterProcessorWithJmxServer$str() {
        return "JBWS022043: Cannot register processor %s with JMX server";
    }
    @Override
    public final void cannotUnregisterProcessorWithJmxServer(final ObjectName processorName, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, cannotUnregisterProcessorWithJmxServer$str(), processorName);
    }
    protected String cannotUnregisterProcessorWithJmxServer$str() {
        return "JBWS022044: Cannot unregister processor %s with JMX server";
    }
    @Override
    public final void startingWSServerConfig(final String implTitle, final String implVersion) {
        super.log.logf(FQCN, INFO, null, startingWSServerConfig$str(), implTitle, implVersion);
    }
    protected String startingWSServerConfig$str() {
        return "JBWS022052: Starting %s %s";
    }
    @Override
    public final void unableToCalculateWebServicesPort(final String def) {
        super.log.logf(FQCN, DEBUG, null, unableToCalculateWebServicesPort$str(), def);
    }
    protected String unableToCalculateWebServicesPort$str() {
        return "JBWS022053: Unable to calculate webservices port, using default %s";
    }
    @Override
    public final void unableToCalculateWebServicesSecurePort(final String def) {
        super.log.logf(FQCN, DEBUG, null, unableToCalculateWebServicesSecurePort$str(), def);
    }
    protected String unableToCalculateWebServicesSecurePort$str() {
        return "JBWS022054: Unable to calculate webservices secure port, using default %s";
    }
    @Override
    public final void usingUndefinedWebServicesHost(final String host) {
        super.log.logf(FQCN, DEBUG, null, usingUndefinedWebServicesHost$str(), host);
    }
    protected String usingUndefinedWebServicesHost$str() {
        return "JBWS022055: Using undefined webservices host: %s";
    }
    @Override
    public final void usingLocalHostWebServicesHost(final String host) {
        super.log.logf(FQCN, DEBUG, null, usingLocalHostWebServicesHost$str(), host);
    }
    protected String usingLocalHostWebServicesHost$str() {
        return "JBWS022056: Setting webservices host to localhost: %s";
    }
    @Override
    public final void couldNotGetAddressForHost(final String host, final Throwable cause) {
        super.log.logf(FQCN, DEBUG, cause, couldNotGetAddressForHost$str(), host);
    }
    protected String couldNotGetAddressForHost$str() {
        return "JBWS022057: Could not get address for host: %s";
    }
    @Override
    public final void couldNotGetPortFromConfiguredHTTPConnector() {
        super.log.logf(FQCN, WARN, null, couldNotGetPortFromConfiguredHTTPConnector$str());
    }
    protected String couldNotGetPortFromConfiguredHTTPConnector$str() {
        return "JBWS022058: Could not get port for webservices configuration from configured HTTP connector";
    }
    @Override
    public final void unableToReadFromHttpServletRequest(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, unableToReadFromHttpServletRequest$str());
    }
    protected String unableToReadFromHttpServletRequest$str() {
        return "JBWS022059: Unable to read from the http servlet request";
    }
    @Override
    public final void cannotTraceSoapMessage(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, cannotTraceSoapMessage$str());
    }
    protected String cannotTraceSoapMessage$str() {
        return "JBWS022060: Cannot trace SOAP message";
    }
    @Override
    public final void methodInvocationFailed(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, methodInvocationFailed$str());
    }
    protected String methodInvocationFailed$str() {
        return "JBWS022061: Method invocation failed with exception";
    }
    @Override
    public final void cannotGetRootFileTryingWithAdditionalMetaData(final String resourcePath) {
        super.log.logf(FQCN, TRACE, null, cannotGetRootFileTryingWithAdditionalMetaData$str(), resourcePath);
    }
    protected String cannotGetRootFileTryingWithAdditionalMetaData$str() {
        return "JBWS022090: Cannot get %s from root file, trying with additional metadata files";
    }
    @Override
    public final void cannotGetRootResourceFrom(final String resourcePath, final Object uvf, final Throwable cause) {
        super.log.logf(FQCN, TRACE, cause, cannotGetRootResourceFrom$str(), resourcePath, uvf);
    }
    protected String cannotGetRootResourceFrom$str() {
        return "JBWS022098: Cannot get %s from %s";
    }
    @Override
    public final void errorDuringDeployment(final String dep, final Throwable cause) {
        super.log.logf(FQCN, DEBUG, cause, errorDuringDeployment$str(), dep);
    }
    protected String errorDuringDeployment$str() {
        return "JBWS022099: Error during deployment: %s";
    }
    @Override
    public final void errorDestroyingDeployment(final String dep, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, errorDestroyingDeployment$str(), dep);
    }
    protected String errorDestroyingDeployment$str() {
        return "JBWS022100: Error while destroying deployment %s due to previous exception";
    }
    @Override
    public final void cannotStopEndpoint(final EndpointState state, final ObjectName epName) {
        super.log.logf(FQCN, ERROR, null, cannotStopEndpoint$str(), state, epName);
    }
    protected String cannotStopEndpoint$str() {
        return "JBWS022102: Cannot stop endpoint in state %s: %s";
    }
    @Override
    public final void cannotStartEndpoint(final EndpointState state, final ObjectName epName) {
        super.log.logf(FQCN, ERROR, null, cannotStartEndpoint$str(), state, epName);
    }
    protected String cannotStartEndpoint$str() {
        return "JBWS022103: Cannot start endpoint in state %s: %s";
    }
    @Override
    public final void cannotAddHandler(final String className, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, cannotAddHandler$str(), className);
    }
    protected String cannotAddHandler$str() {
        return "JBWS022110: Could not add handler %s as part of client or endpoint configuration";
    }
    @Override
    public final void filtersNotSupported() {
        super.log.logf(FQCN, WARN, null, filtersNotSupported$str());
    }
    protected String filtersNotSupported$str() {
        return "JBWS022111: PortNamePattern and ServiceNamePattern filters not supported; adding handlers anyway";
    }
    @Override
    public final void initParamsNotSupported() {
        super.log.logf(FQCN, WARN, null, initParamsNotSupported$str());
    }
    protected String initParamsNotSupported$str() {
        return "JBWS022112: Init params not supported; adding handler anyway";
    }
    @Override
    public final void errorClosingJAXBIntroConf(final URL url, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, errorClosingJAXBIntroConf$str(), url);
    }
    protected String errorClosingJAXBIntroConf$str() {
        return "JBWS022113: Error closing JAXBIntro configuration stream: %s";
    }
    @Override
    public final void aspectDoesNotWorkOnDeployment(final Class<?> aspect, final Class<?> deployment) {
        super.log.logf(FQCN, TRACE, null, aspectDoesNotWorkOnDeployment$str(), aspect, deployment);
    }
    protected String aspectDoesNotWorkOnDeployment$str() {
        return "JBWS022114: %s doesn't work on %s";
    }
    @Override
    public final void cannotGetURLFor(final String path) {
        super.log.logf(FQCN, TRACE, null, cannotGetURLFor$str(), path);
    }
    protected String cannotGetURLFor$str() {
        return "JBWS022115: Cannot get URL for %s";
    }
    @Override
    public final void cannotFindInAdditionalMetaData(final String resourcePath) {
        super.log.logf(FQCN, TRACE, null, cannotFindInAdditionalMetaData$str(), resourcePath);
    }
    protected String cannotFindInAdditionalMetaData$str() {
        return "JBWS022116: Could not find %s in the additional metadatafiles";
    }
    @Override
    public final void cannotObtainHost(final String host) {
        super.log.logf(FQCN, WARN, null, cannotObtainHost$str(), host);
    }
    protected String cannotObtainHost$str() {
        return "JBWS022118: Cannot obtain host for vituralHost %s, use default host";
    }
    @Override
    public final void cannotObtainPort(final String host) {
        super.log.logf(FQCN, WARN, null, cannotObtainPort$str(), host);
    }
    protected String cannotObtainPort$str() {
        return "JBWS022119: Cannot obtain port for vituralHost %s, use default port";
    }
}
