/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss42;

import java.util.Map;
import javax.servlet.Servlet;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.metadata.WebMetaData;
import org.jboss.wsf.common.URLLoaderAdapter;
import org.jboss.wsf.container.jboss42.AbstractDeployerHookJSE;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.Service;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.webservices.PortComponentMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebserviceDescriptionMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;

public class JAXRPCDeployerHookPreJSE
extends AbstractDeployerHookJSE {
    public void undeploy(DeploymentInfo unit) {
    }

    public Deployment.DeploymentType getDeploymentType() {
        return Deployment.DeploymentType.JAXRPC_JSE;
    }

    public Deployment createDeployment(DeploymentInfo di) {
        ArchiveDeployment dep = this.newDeployment(di);
        dep.setRootFile((UnifiedVirtualFile)new URLLoaderAdapter(di.localUrl));
        dep.setRuntimeClassLoader(null);
        dep.setType(this.getDeploymentType());
        Service service = dep.getService();
        WebMetaData webMetaData = (WebMetaData)di.metaData;
        if (webMetaData == null) {
            throw new IllegalStateException("Deployment unit does not contain web meta data");
        }
        WebservicesMetaData wsMetaData = this.getWebservicesMetaData(di, "WEB-INF/webservices.xml");
        if (wsMetaData == null) {
            throw new IllegalStateException("Deployment unit does not contain webservices meta data");
        }
        dep.addAttachment(WebservicesMetaData.class, (Object)wsMetaData);
        dep.addAttachment(WebMetaData.class, (Object)webMetaData);
        for (WebserviceDescriptionMetaData wsd : wsMetaData.getWebserviceDescriptions()) {
            for (PortComponentMetaData pcmd : wsd.getPortComponents()) {
                String servletLink = pcmd.getServletLink();
                if (servletLink == null) {
                    throw new IllegalStateException("servlet-link cannot be null");
                }
                AbstractDeployerHookJSE.Servlet servlet = this.getServletForName(webMetaData, servletLink);
                String servletClass = servlet.getServletClass();
                try {
                    ClassLoader loader = dep.getInitialClassLoader();
                    Class<?> epBean = loader.loadClass(servletClass.trim());
                    if (Servlet.class.isAssignableFrom(epBean)) {
                        servletClass = null;
                    }
                }
                catch (ClassNotFoundException ex) {
                    this.log.warn((Object)("Cannot load servlet class: " + servletClass));
                }
                Endpoint ep = this.newEndpoint(servletClass);
                ep.setShortName(servletLink);
                service.addEndpoint(ep);
            }
        }
        return dep;
    }

    private AbstractDeployerHookJSE.Servlet getServletForName(WebMetaData wmd, String servletLink) {
        for (Map.Entry entry : wmd.getServletClassMap().entrySet()) {
            String servletName = (String)entry.getKey();
            String servletClass = (String)entry.getValue();
            if (!servletLink.equals(servletName)) continue;
            return new AbstractDeployerHookJSE.Servlet(servletName, servletClass);
        }
        throw new IllegalStateException("Cannot find servlet for link: " + servletLink);
    }

    public boolean isWebServiceDeployment(DeploymentInfo unit) {
        if (!super.isWebServiceDeployment(unit) || unit.context.get("org.jboss.ws.ejbwebapp") != null) {
            return false;
        }
        WebservicesMetaData wsMetaData = this.getWebservicesMetaData(unit, "WEB-INF/webservices.xml");
        return wsMetaData != null;
    }
}

