/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50;

import org.jboss.logging.Logger;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.WSFRuntime;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspectManager;
import org.jboss.wsf.spi.invocation.InvocationHandlerFactory;
import org.jboss.wsf.spi.invocation.RequestHandlerFactory;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointRegistryFactory;
import org.jboss.wsf.spi.transport.TransportManagerFactory;

public class BareWSFRuntime
implements WSFRuntime {
    private static final Logger log = Logger.getLogger(BareWSFRuntime.class);
    private String runtimeName;
    private DeploymentAspectManager deploymentManager;
    private EndpointRegistry endpointRegistry;
    private RequestHandlerFactory requestHandlerFactory;
    private InvocationHandlerFactory invocationHandlerFactory;
    private TransportManagerFactory transportManagerFactory;
    boolean initialized;

    public BareWSFRuntime(String runtimeName) {
        this.runtimeName = runtimeName;
    }

    public void create(Deployment deployment) {
        this.init();
        this.deploymentManager.create(deployment, (WSFRuntime)this);
    }

    private void init() {
        if (!this.initialized) {
            SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
            this.setEndpointRegistry(((EndpointRegistryFactory)spiProvider.getSPI(EndpointRegistryFactory.class)).getEndpointRegistry());
            this.setRequestHandlerFactory((RequestHandlerFactory)spiProvider.getSPI(RequestHandlerFactory.class));
            this.setInvocationHandlerFactory((InvocationHandlerFactory)spiProvider.getSPI(InvocationHandlerFactory.class));
            this.initialized = true;
        }
    }

    public void start(Deployment deployment) {
        this.init();
        this.deploymentManager.start(deployment, (WSFRuntime)this);
    }

    public void stop(Deployment deployment) {
        this.init();
        this.deploymentManager.stop(deployment, (WSFRuntime)this);
    }

    public void destroy(Deployment deployment) {
        this.init();
        this.deploymentManager.destroy(deployment, (WSFRuntime)this);
    }

    public void setTransportManagerFactory(TransportManagerFactory factory) {
        assert (factory != null);
        log.debug((Object)(this.runtimeName + " -> TransportManagerFactory: " + factory));
        this.transportManagerFactory = factory;
    }

    public TransportManagerFactory getTransportManagerFactory() {
        return this.transportManagerFactory;
    }

    public void setEndpointRegistry(EndpointRegistry endpointRegistry) {
        assert (endpointRegistry != null);
        log.debug((Object)(this.runtimeName + " -> EndpointRegistry: " + endpointRegistry));
        this.endpointRegistry = endpointRegistry;
    }

    public EndpointRegistry getEndpointRegistry() {
        return this.endpointRegistry;
    }

    public void setDeploymentAspectManager(DeploymentAspectManager deploymentManager) {
        assert (deploymentManager != null);
        log.debug((Object)(this.runtimeName + " -> DeploymentAspectManager: " + deploymentManager));
        this.deploymentManager = deploymentManager;
    }

    public DeploymentAspectManager getDeploymentAspectManager() {
        return this.deploymentManager;
    }

    public void setRequestHandlerFactory(RequestHandlerFactory factory) {
        assert (factory != null);
        log.debug((Object)(this.runtimeName + " -> RequestHandlerFactory: " + factory));
        this.requestHandlerFactory = factory;
    }

    public RequestHandlerFactory getRequestHandlerFactory() {
        return this.requestHandlerFactory;
    }

    public void setInvocationHandlerFactory(InvocationHandlerFactory factory) {
        assert (factory != null);
        log.debug((Object)(this.runtimeName + " -> InvocationHandlerFactory: " + factory));
        this.invocationHandlerFactory = factory;
    }

    public InvocationHandlerFactory getInvocationHandlerFactory() {
        return this.invocationHandlerFactory;
    }

    public String toString() {
        return this.runtimeName + ": " + super.toString();
    }
}

