/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservices.integration.invocation;

import java.lang.reflect.Method;
import java.security.Principal;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.ws.WebServiceException;
import org.jboss.ejb.EjbModule;
import org.jboss.ejb.Interceptor;
import org.jboss.ejb.StatelessSessionContainer;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationKey;
import org.jboss.invocation.InvocationType;
import org.jboss.invocation.PayloadKey;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.webservices.integration.invocation.ServiceEndpointInterceptorEJB21;
import org.jboss.ws.common.ObjectNameFactory;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.ws.common.invocation.AbstractInvocationHandler;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.HandlerCallback;
import org.jboss.wsf.spi.invocation.SecurityAdaptor;
import org.jboss.wsf.spi.invocation.SecurityAdaptorFactory;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;

final class InvocationHandlerEJB21
extends AbstractInvocationHandler {
    private String jndiName;
    private MBeanServer server = MBeanServerLocator.locateJBoss();
    private ObjectName ejb21ContainerName;

    InvocationHandlerEJB21() {
    }

    public void init(Endpoint endpoint) {
        String ejbName = endpoint.getShortName();
        Deployment dep = endpoint.getService().getDeployment();
        EJBArchiveMetaData ejbArchiveMD = (EJBArchiveMetaData)WSHelper.getRequiredAttachment((Deployment)dep, EJBArchiveMetaData.class);
        EJBMetaData ejbMD = ejbArchiveMD.getBeanByEjbName(ejbName);
        if (ejbMD == null) {
            throw new WebServiceException("Cannot obtain ejb meta data for: " + ejbName);
        }
        this.jndiName = ejbMD.getContainerObjectNameJndiName();
        if (this.jndiName == null) {
            throw new WebServiceException("Cannot obtain JNDI name for: " + ejbName);
        }
    }

    private synchronized ObjectName getEjb21ContainerName(Endpoint endpoint) {
        boolean ejb21ContainerNotInitialized;
        boolean bl = ejb21ContainerNotInitialized = this.ejb21ContainerName == null;
        if (ejb21ContainerNotInitialized) {
            boolean ejb21NotRegistered;
            this.ejb21ContainerName = ObjectNameFactory.create((String)("jboss.j2ee:jndiName=" + this.jndiName + ",service=EJB"));
            boolean bl2 = ejb21NotRegistered = !this.server.isRegistered(this.ejb21ContainerName);
            if (ejb21NotRegistered) {
                throw new IllegalArgumentException("Cannot find service endpoint target: " + this.ejb21ContainerName);
            }
            this.insertEJB21ServiceEndpointInterceptor(this.ejb21ContainerName, endpoint.getShortName());
        }
        return this.ejb21ContainerName;
    }

    public void invoke(Endpoint endpoint, org.jboss.wsf.spi.invocation.Invocation wsInvocation) throws Exception {
        ObjectName ejb21Name = this.getEjb21ContainerName(endpoint);
        try {
            Invocation jbossInvocation = this.getMBeanInvocation(wsInvocation);
            String[] signature = new String[]{Invocation.class.getName()};
            Object[] args = new Object[]{jbossInvocation};
            Object retObj = this.server.invoke(ejb21Name, "invoke", args, signature);
            wsInvocation.setReturnValue(retObj);
        }
        catch (Exception e) {
            this.log.error((Object)("Method invocation failed with exception: " + e.getMessage()), (Throwable)e);
            this.handleInvocationException(e);
        }
    }

    private Invocation getMBeanInvocation(org.jboss.wsf.spi.invocation.Invocation wsInvocation) {
        MessageContext msgContext = (MessageContext)wsInvocation.getInvocationContext().getAttachment(MessageContext.class);
        if (msgContext == null) {
            throw new IllegalStateException("Cannot obtain MessageContext");
        }
        HandlerCallback callback = (HandlerCallback)wsInvocation.getInvocationContext().getAttachment(HandlerCallback.class);
        if (callback == null) {
            throw new IllegalStateException("Cannot obtain HandlerCallback");
        }
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        SecurityAdaptor securityAdaptor = ((SecurityAdaptorFactory)spiProvider.getSPI(SecurityAdaptorFactory.class)).newSecurityAdapter();
        Principal principal = securityAdaptor.getPrincipal();
        Object credential = securityAdaptor.getCredential();
        Method method = wsInvocation.getJavaMethod();
        Object[] args = wsInvocation.getArgs();
        Invocation jbossInvocation = new Invocation(null, method, args, null, principal, credential);
        jbossInvocation.setValue((Object)InvocationKey.SOAP_MESSAGE_CONTEXT, (Object)msgContext);
        jbossInvocation.setValue((Object)InvocationKey.SOAP_MESSAGE, (Object)((SOAPMessageContext)msgContext).getMessage());
        jbossInvocation.setType(InvocationType.SERVICE_ENDPOINT);
        jbossInvocation.setValue((Object)HandlerCallback.class.getName(), (Object)callback, PayloadKey.TRANSIENT);
        jbossInvocation.setValue((Object)org.jboss.wsf.spi.invocation.Invocation.class.getName(), (Object)wsInvocation, PayloadKey.TRANSIENT);
        return jbossInvocation;
    }

    private void insertEJB21ServiceEndpointInterceptor(ObjectName objectName, String ejbName) {
        try {
            EjbModule ejbModule = (EjbModule)this.server.getAttribute(objectName, "EjbModule");
            StatelessSessionContainer container = (StatelessSessionContainer)ejbModule.getContainer(ejbName);
            Interceptor currentInterceptor = container.getInterceptor();
            while (currentInterceptor != null && currentInterceptor.getNext() != null) {
                Interceptor nextInterceptor = currentInterceptor.getNext();
                if (nextInterceptor.getNext() == null) {
                    ServiceEndpointInterceptorEJB21 sepInterceptor = new ServiceEndpointInterceptorEJB21();
                    currentInterceptor.setNext((Interceptor)sepInterceptor);
                    sepInterceptor.setNext(nextInterceptor);
                    this.log.debug((Object)("Injecting EJB 21 service endpoint interceptor after: " + currentInterceptor.getClass().getName()));
                    return;
                }
                currentInterceptor = nextInterceptor;
            }
            this.log.warn((Object)"Cannot find EJB 21 service endpoint interceptor insert point");
        }
        catch (Exception ex) {
            this.log.warn((Object)"Cannot register EJB 21 service endpoint interceptor: ", (Throwable)ex);
        }
    }
}

