/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservices.integration.invocation;

import java.lang.reflect.Method;
import java.security.Principal;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.context.CurrentEJBContext;
import org.jboss.ws.common.injection.ThreadLocalAwareWebServiceContext;
import org.jboss.ws.common.invocation.AbstractInvocationHandler;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.Invocation;
import org.jboss.wsf.spi.invocation.InvocationContext;
import org.jboss.wsf.spi.invocation.integration.InvocationContextCallback;
import org.jboss.wsf.spi.invocation.integration.ServiceEndpointContainer;
import org.jboss.wsf.spi.ioc.IoCContainerProxy;
import org.jboss.wsf.spi.ioc.IoCContainerProxyFactory;
import org.w3c.dom.Element;

final class InvocationHandlerEJB3
extends AbstractInvocationHandler {
    private static final String EJB3_JNDI_PREFIX = "java:env/";
    private final IoCContainerProxy iocContainer;
    private String containerName;
    private ServiceEndpointContainer serviceEndpointContainer;

    InvocationHandlerEJB3() {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        IoCContainerProxyFactory iocContainerFactory = (IoCContainerProxyFactory)spiProvider.getSPI(IoCContainerProxyFactory.class);
        this.iocContainer = iocContainerFactory.getContainer();
    }

    public void init(Endpoint endpoint) {
        this.containerName = (String)endpoint.getProperty("org.jboss.wsf.spi.invocation.ContainerName");
        if (this.containerName == null) {
            throw new IllegalArgumentException("Container name cannot be null");
        }
    }

    private synchronized ServiceEndpointContainer getEjb3Container() {
        boolean ejb3ContainerNotInitialized;
        boolean bl = ejb3ContainerNotInitialized = this.serviceEndpointContainer == null;
        if (ejb3ContainerNotInitialized) {
            this.serviceEndpointContainer = (ServiceEndpointContainer)this.iocContainer.getBean(this.containerName, ServiceEndpointContainer.class);
            if (this.serviceEndpointContainer == null) {
                throw new WebServiceException("Cannot find service endpoint target: " + this.containerName);
            }
        }
        return this.serviceEndpointContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Endpoint endpoint, Invocation wsInvocation) throws Exception {
        try {
            this.onBeforeInvocation(wsInvocation);
            ServiceEndpointContainer ejbContainer = this.getEjb3Container();
            EJB3InvocationContextCallback invocationCallback = new EJB3InvocationContextCallback(wsInvocation);
            Class implClass = ejbContainer.getServiceImplementationClass();
            Method seiMethod = wsInvocation.getJavaMethod();
            Method implMethod = this.getImplMethod(implClass, seiMethod);
            Object[] args = wsInvocation.getArgs();
            Object retObj = ejbContainer.invokeEndpoint(implMethod, args, (InvocationContextCallback)invocationCallback);
            wsInvocation.setReturnValue(retObj);
        }
        catch (Throwable t) {
            this.log.error((Object)("Method invocation failed with exception: " + t.getMessage()), t);
            this.handleInvocationException(t);
        }
        finally {
            this.onAfterInvocation(wsInvocation);
        }
    }

    public Context getJNDIContext(Endpoint ep) throws NamingException {
        EJBContainer ejb3Container = (EJBContainer)this.getEjb3Container();
        return (Context)ejb3Container.getEnc().lookup(EJB3_JNDI_PREFIX);
    }

    public void onBeforeInvocation(Invocation invocation) {
        WebServiceContext wsContext = this.getWebServiceContext(invocation);
        ThreadLocalAwareWebServiceContext.getInstance().setMessageContext(wsContext);
    }

    public void onAfterInvocation(Invocation invocation) {
        ThreadLocalAwareWebServiceContext.getInstance().setMessageContext(null);
    }

    private WebServiceContext getWebServiceContext(Invocation invocation) {
        InvocationContext invocationContext = invocation.getInvocationContext();
        return new WebServiceContextAdapter((WebServiceContext)invocationContext.getAttachment(WebServiceContext.class));
    }

    private static final class EJB3InvocationContextCallback
    implements InvocationContextCallback {
        private Invocation wsInvocation;

        public EJB3InvocationContextCallback(Invocation wsInvocation) {
            this.wsInvocation = wsInvocation;
        }

        public <T> T get(Class<T> attachmentType) {
            return (T)this.wsInvocation.getInvocationContext().getAttachment(attachmentType);
        }
    }

    private static final class WebServiceContextAdapter
    implements WebServiceContext {
        private final WebServiceContext delegate;

        private WebServiceContextAdapter(WebServiceContext delegate) {
            this.delegate = delegate;
        }

        public MessageContext getMessageContext() {
            return this.delegate.getMessageContext();
        }

        public Principal getUserPrincipal() {
            return CurrentEJBContext.get().getCallerPrincipal();
        }

        public boolean isUserInRole(String role) {
            return CurrentEJBContext.get().isCallerInRole(role);
        }

        public EndpointReference getEndpointReference(Element ... referenceParameters) {
            return this.delegate.getEndpointReference(referenceParameters);
        }

        public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element ... referenceParameters) {
            return (T)this.delegate.getEndpointReference(clazz, referenceParameters);
        }
    }
}

